/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.InventoryUtil;
import forestry.factory.inventory.InventoryCraftingForestry;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MemorizedRecipe
implements INbtWritable,
INbtReadable,
IStreamable {
    private InventoryCraftingForestry craftMatrix = new InventoryCraftingForestry();
    private List<IRecipe> recipes = NonNullList.func_191196_a();
    private int selectedRecipe;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe(PacketBufferForestry data, World world) throws IOException {
        this.readData(data, world);
    }

    public MemorizedRecipe(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public MemorizedRecipe(InventoryCraftingForestry craftMatrix, List<IRecipe> recipes) {
        InventoryUtil.deepCopyInventoryContents((IInventory)craftMatrix, (IInventory)this.craftMatrix);
        this.recipes = recipes;
    }

    public InventoryCraftingForestry getCraftMatrix() {
        return this.craftMatrix;
    }

    public void setCraftMatrix(InventoryCraftingForestry craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    public void validate(World world) {
        this.recipes = RecipeUtil.findMatchingRecipes(this.craftMatrix, world);
        if (this.selectedRecipe > this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void incrementRecipe() {
        ++this.selectedRecipe;
        if (this.selectedRecipe >= this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void decrementRecipe() {
        --this.selectedRecipe;
        if (this.selectedRecipe < 0) {
            this.selectedRecipe = this.recipes.size() - 1;
        }
    }

    public boolean hasRecipeConflict() {
        return this.recipes.size() > 1;
    }

    public void removeRecipeConflicts() {
        IRecipe recipe = this.getSelectedRecipe();
        this.recipes.clear();
        this.recipes.add(recipe);
        this.selectedRecipe = 0;
    }

    public ItemStack getOutputIcon() {
        ItemStack recipeOutput;
        IRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && !(recipeOutput = selectedRecipe.func_77572_b((InventoryCrafting)this.craftMatrix)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting, World world) {
        ItemStack recipeOutput;
        IRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && selectedRecipe.func_77569_a(inventoryCrafting, world) && !(recipeOutput = selectedRecipe.func_77572_b(inventoryCrafting)).func_190926_b()) {
            return recipeOutput;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public IRecipe getSelectedRecipe() {
        if (this.recipes.isEmpty()) {
            return null;
        }
        return this.recipes.get(this.selectedRecipe);
    }

    public boolean hasRecipe(@Nullable IRecipe recipe) {
        return this.recipes.contains(recipe);
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.readFromNBT((IInventory)this.craftMatrix, nbttagcompound);
        this.lastUsed = nbttagcompound.func_74763_f("LastUsed");
        this.locked = nbttagcompound.func_74767_n("Locked");
        if (nbttagcompound.func_74764_b("SelectedRecipe")) {
            this.selectedRecipe = nbttagcompound.func_74762_e("SelectedRecipe");
        }
        this.recipes.clear();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.writeToNBT((IInventory)this.craftMatrix, nbttagcompound);
        nbttagcompound.func_74772_a("LastUsed", this.lastUsed);
        nbttagcompound.func_74757_a("Locked", this.locked);
        nbttagcompound.func_74768_a("SelectedRecipe", this.selectedRecipe);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInventory((IInventory)this.craftMatrix);
        data.writeBoolean(this.locked);
        data.func_150787_b(this.selectedRecipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        this.readData(data, (World)Minecraft.func_71410_x().field_71441_e);
    }

    public void readData(PacketBufferForestry data, World world) throws IOException {
        data.readInventory((IInventory)this.craftMatrix);
        this.locked = data.readBoolean();
        this.selectedRecipe = data.func_150792_a();
        this.recipes.clear();
        this.validate(world);
    }
}

