/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail.items;

import forestry.api.mail.EnumPostage;
import forestry.api.mail.IStamps;
import forestry.core.CreativeTabForestry;
import forestry.core.items.ItemOverlay;
import net.minecraft.item.ItemStack;

public class ItemStamps extends ItemOverlay implements IStamps {
	public ItemStamps() {
		super(CreativeTabForestry.tabForestry, EnumStampDefinition.VALUES);
	}

	@Override
	public EnumPostage getPostage(ItemStack itemstack) {
		if (itemstack.func_77973_b() != this) {
			return EnumPostage.P_0;
		}

		if (itemstack.func_77952_i() < 0 || itemstack.func_77952_i() >= EnumStampDefinition.VALUES.length) {
			return EnumPostage.P_0;
		}

		return EnumStampDefinition.VALUES[itemstack.func_77952_i()].getPostage();
	}

	public ItemStack get(EnumStampDefinition stampInfo, int amount) {
		return new ItemStack(this, amount, stampInfo.ordinal());
	}
}
