/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.core.PluginCore;
import forestry.core.PluginFluids;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.compat.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

@ForestryPlugin(pluginID="forestry.harvestcraft", name="HarvestCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.harvestcraft.description")
public class PluginHarvestCraft
extends CompatPlugin {
    private static final String HC = "harvestcraft";

    public PluginHarvestCraft() {
        super("HarvestCraft", HC);
    }

    @Override
    public void registerRecipes() {
        ItemStack hcBeeswaxItem;
        Block fruitBlock;
        ImmutableList berries = ImmutableList.of((Object)"cranberry", (Object)"blackberry", (Object)"blueberry", (Object)"raspberry", (Object)"strawberry");
        ImmutableList fruits = ImmutableList.of((Object)"pineapple", (Object)"cactusfruit", (Object)"cantaloupe", (Object)"grape", (Object)"kiwi", (Object)"chilipepper");
        ImmutableList treeFruits = ImmutableList.of((Object)"banana", (Object)"dragonfruit", (Object)"lemon", (Object)"lime", (Object)"mango", (Object)"orange", (Object)"papaya", (Object)"peach", (Object)"pear", (Object)"plum", (Object)"pomegranate", (Object)"starfruit", (Object[])new String[]{"apricot", "date", "fig", "grapefruit", "persimmon", "avocado", "coconut", "durian"});
        ImmutableList trees = ImmutableList.of((Object)"nutmeg", (Object)"olive", (Object)"peppercorn");
        ImmutableList treesSpecial = ImmutableList.of((Object)"cinnamon", (Object)"maple", (Object)"paperbark", (Object)"vanillabean", (Object)"apple");
        ImmutableList herbs = ImmutableList.of((Object)"garlic");
        ImmutableList spices = ImmutableList.of((Object)"ginger", (Object)"spiceleaf");
        ImmutableList vegetables = ImmutableList.of((Object)"asparagus", (Object)"bean", (Object)"beet", (Object)"broccoli", (Object)"cauliflower", (Object)"celery", (Object)"leek", (Object)"lettuce", (Object)"onion", (Object)"parsnip", (Object)"radish", (Object)"rutabaga", (Object[])new String[]{"scallion", "soybean", "sweetpotato", "turnip", "whitemushroom", "artichoke", "bellpepper", "brusselsprout", "cabbage", "corn", "cucumber", "eggplant", "okra", "peas", "rhubarb", "seaweed", "tomato", "wintersquash", "zucchini", "bambooshoot", "spinach"});
        ImmutableList grains = ImmutableList.of((Object)"barley", (Object)"oats", (Object)"rye");
        ImmutableList cropNuts = ImmutableList.of((Object)"peanut");
        ImmutableList nuts = ImmutableList.of((Object)"walnut", (Object)"almond", (Object)"cashew", (Object)"chestnut", (Object)"pecan", (Object)"pistachio", (Object)"cherry");
        ImmutableList.Builder genericCropsBuilder = ImmutableList.builder();
        genericCropsBuilder.add((Object[])new String[]{"cotton", "rice", "tea", "coffee", "candleberry"});
        genericCropsBuilder.addAll((Iterable)herbs);
        genericCropsBuilder.addAll((Iterable)spices);
        IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
        ImmutableList genericCrops = genericCropsBuilder.build();
        ImmutableList.Builder plants = ImmutableList.builder();
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int wheatamount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
        PropertyInteger plantAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
        PropertyInteger fruitAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
        juiceAmount = Math.max(juiceAmount, 1);
        for (String berryName : berries) {
            ItemStack berry = this.getItemStack(berryName + "Item");
            ItemStack berrySeed = this.getItemStack(berryName + "seedItem");
            Block berryBlock = this.getBlock("pam" + berryName + "Crop");
            if (berry != null) {
                RecipeManagers.squeezerManager.addRecipe(10, berry, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (berrySeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, berrySeed, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && berrySeed != null && berryBlock != null) {
                farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(berrySeed, berryBlock, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(berrySeed, berryBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)berryName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        for (String fruitName : fruits) {
            ItemStack fruit = this.getItemStack(fruitName + "Item");
            ItemStack fruitSeed = this.getItemStack(fruitName + "seedItem");
            Block fruitBlock2 = this.getBlock("pam" + fruitName + "Crop");
            if (fruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, fruit, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (fruitSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, fruitSeed, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && fruitSeed != null && fruitBlock2 != null) {
                farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(fruitSeed, fruitBlock2, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(fruitSeed, fruitBlock2, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)fruitName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        juiceAmount = Math.max(juiceAmount, 1);
        for (String vegetableName : vegetables) {
            ItemStack vegetable = this.getItemStack(vegetableName + "Item");
            ItemStack vegetableSeed = this.getItemStack(vegetableName + "seedItem");
            Block vegetableBlock = this.getBlock("pam" + vegetableName + "Crop");
            if (vegetable != null) {
                RecipeManagers.squeezerManager.addRecipe(10, vegetable, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (vegetableSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, vegetableSeed, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && vegetableSeed != null && vegetableBlock != null) {
                farmRegistry.registerFarmables("farmVegetables", new FarmableAgingCrop(vegetableSeed, vegetableBlock, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(vegetableSeed, vegetableBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)vegetableName);
        }
        ItemRegistryCore coreItems = PluginCore.getItems();
        for (String grainName : grains) {
            ItemStack grain = this.getItemStack(grainName + "Item");
            ItemStack grainSeed = this.getItemStack(grainName + "seedItem");
            Block grainBlock = this.getBlock("pam" + grainName + "Crop");
            if (grain != null && wheatamount > 0) {
                RecipeUtil.addRecipe(coreItems.fertilizerBio.getItemStack(wheatamount), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), grain);
                FuelManager.moistenerResource.put(grain, new MoistenerFuel(grain, coreItems.mouldyWheat.getItemStack(), 0, 300));
            }
            if (grainSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, grainSeed, Fluids.SEED_OIL.getFluid(seedamount));
                RecipeManagers.moistenerManager.addRecipe(grainSeed, new ItemStack((Block)Blocks.field_150391_bh), 5000);
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && grainSeed != null && grainBlock != null) {
                farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(grainSeed, grainBlock, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(grainSeed, grainBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)grainName);
        }
        for (String treeFruitName : treeFruits) {
            ItemStack treeFruit = this.getItemStack(treeFruitName + "Item");
            Block treeFruitBlock = this.getBlock("pam" + Character.toUpperCase(treeFruitName.charAt(0)) + treeFruitName.substring(1));
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && treeFruitBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, treeFruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            if (treeFruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, treeFruit, Fluids.JUICE.getFluid(juiceAmount));
            }
            plants.add((Object)treeFruitName);
        }
        for (String treeName : trees) {
            fruitBlock = this.getBlock("pam" + Character.toUpperCase(treeName.charAt(0)) + treeName.substring(1));
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && fruitBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, fruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            plants.add((Object)treeName);
        }
        for (String treeName : treesSpecial) {
            fruitBlock = this.getBlock("pam" + Character.toUpperCase(treeName.charAt(0)) + treeName.substring(1));
            if (!ForestryAPI.enabledPlugins.contains("forestry.farming") || fruitBlock == null) continue;
            farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, fruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
        }
        for (String cropName : genericCrops) {
            ItemStack genericCropSeed = this.getItemStack(cropName + "seedItem");
            UnmodifiableIterator genericCropBlock = this.getBlock("pam" + cropName + "Crop");
            if (genericCropSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, genericCropSeed, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && genericCropSeed != null && genericCropBlock != null) {
                farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(genericCropSeed, (Block)genericCropBlock, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(genericCropSeed, (Block)genericCropBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)cropName);
        }
        ItemStack mustardCropSeed = this.getItemStack("mustardseedItem");
        Block mustardCropBlock = this.getBlock("pammustardseedsCrop");
        ItemStack mustardFruit = this.getItemStack("mustardseedsItem");
        if (mustardCropSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, mustardCropSeed, Fluids.SEED_OIL.getFluid(seedamount));
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && mustardCropSeed != null && mustardCropBlock != null) {
            farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(mustardCropSeed, mustardCropBlock, (IProperty<Integer>)plantAGE, 3));
            farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(mustardCropSeed, mustardCropBlock, (IProperty<Integer>)plantAGE, 3, 0));
        }
        if (mustardFruit != null) {
            RecipeUtil.addFermenterRecipes(mustardFruit, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String plantName : plants.build()) {
            ItemStack plant = this.getItemStack(plantName + "Item");
            if (plant == null) continue;
            RecipeUtil.addFermenterRecipes(plant, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String cropnutName : cropNuts) {
            ItemStack cropnut = this.getItemStack(cropnutName + "Item");
            ItemStack cropnutSeed = this.getItemStack(cropnutName + "seedItem");
            Block cropnutBlock = this.getBlock("pam" + cropnutName + "Crop");
            if (cropnutSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, cropnutSeed, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && cropnutSeed != null && cropnutBlock != null) {
                farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(cropnutSeed, cropnutBlock, (IProperty<Integer>)plantAGE, 3));
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(cropnutSeed, cropnutBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            if (cropnut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, cropnut, Fluids.SEED_OIL.getFluid(12 * seedamount));
        }
        for (String nutName : nuts) {
            ItemStack nut = this.getItemStack(nutName + "Item");
            Block nutBlock = this.getBlock("pam" + Character.toUpperCase(nutName.charAt(0)) + nutName.substring(1));
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && nutBlock != null) {
                farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(ItemStack.field_190927_a, nutBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            if (nut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, nut, Fluids.SEED_OIL.getFluid(15 * seedamount));
        }
        ItemStack hcHoneyItem = this.getItemStack("honeyItem");
        if (hcHoneyItem != null) {
            RecipeManagers.squeezerManager.addRecipe(10, hcHoneyItem, Fluids.FOR_HONEY.getFluid(100));
        }
        if ((hcBeeswaxItem = this.getItemStack("beeswaxItem")) != null) {
            RecipeUtil.addRecipe(PluginFluids.getItems().waxCapsuleEmpty.getItemStack(ForestryAPI.activeMode.getIntegerSetting("recipe.output.capsule")), "XXX ", Character.valueOf('X'), hcBeeswaxItem);
        }
    }
}

