/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.inventory.ItemInventoryImprinter;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class GuiImprinter
extends GuiForestry<ContainerImprinter> {
    private final ItemInventoryImprinter itemInventory;
    private int startX;
    private int startY;
    private final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    public GuiImprinter(InventoryPlayer inventoryplayer, ItemInventoryImprinter itemInventory) {
        super("textures/gui/imprinter.png", new ContainerImprinter(inventoryplayer, itemInventory));
        this.itemInventory = itemInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 185;
        NonNullList beeList = NonNullList.func_191196_a();
        PluginApiculture.getItems().beeDroneGE.addCreativeItems((NonNullList<ItemStack>)beeList, false);
        for (ItemStack beeStack : beeList) {
            IAlleleBeeSpecies species = BeeGenome.getSpecies(beeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), beeStack);
        }
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        int offset = (138 - this.field_146289_q.func_78256_a(Translator.translateToLocal("for.gui.imprinter.name"))) / 2;
        this.field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.imprinter.name"), this.startX + 8 + offset, this.startY + 16, ColourProperties.INSTANCE.get("gui.screen"));
        IAlleleBeeSpecies primary = this.itemInventory.getPrimary();
        this.drawBeeSpeciesIcon(primary, this.startX + 12, this.startY + 32);
        this.field_146289_q.func_78276_b(primary.getAlleleName(), this.startX + 32, this.startY + 36, ColourProperties.INSTANCE.get("gui.screen"));
        IAlleleBeeSpecies secondary = this.itemInventory.getSecondary();
        this.drawBeeSpeciesIcon(secondary, this.startX + 12, this.startY + 52);
        this.field_146289_q.func_78276_b(secondary.getAlleleName(), this.startX + 32, this.startY + 56, ColourProperties.INSTANCE.get("gui.screen"));
        String youCheater = Translator.translateToLocal("for.gui.imprinter.cheater");
        offset = (138 - this.field_146289_q.func_78256_a(youCheater)) / 2;
        this.field_146289_q.func_78276_b(youCheater, this.startX + 8 + offset, this.startY + 76, ColourProperties.INSTANCE.get("gui.screen"));
    }

    private void drawBeeSpeciesIcon(IAlleleBeeSpecies bee, int x, int y) {
        GuiUtil.drawItemStack(this, this.iconStacks.get(bee.getUID()), x, y);
    }

    private static int getHabitatSlotAtPosition(int i, int j) {
        int[] xPos = new int[]{12, 12};
        int[] yPos = new int[]{32, 52};
        for (int l = 0; l < xPos.length; ++l) {
            if (i < xPos[l] || i > xPos[l] + 16 || j < yPos[l] || j > yPos[l] + 16) continue;
            return l;
        }
        return -1;
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        int slot = GuiImprinter.getHabitatSlotAtPosition(i - cornerX, j - cornerY);
        if (slot < 0) {
            return;
        }
        if (k == 0) {
            GuiImprinter.advanceSelection(slot);
        } else {
            GuiImprinter.regressSelection(slot);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.startX = (this.field_146294_l - this.field_146999_f) / 2;
        this.startY = (this.field_146295_m - this.field_147000_g) / 2;
    }

    private static void advanceSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 0);
    }

    private static void regressSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 1);
    }

    private static void sendSelectionChange(int index, int advance) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(index, advance));
    }

    @Override
    protected void addLedgers() {
    }
}

