/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import com.google.common.base.Predicate;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.blocks.IColoredBlock;
import forestry.core.config.Config;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHoneyComb
extends Block
implements IItemModelRegister,
IBlockWithMeta,
IColoredBlock,
IStateMapperRegister {
    public final int minMeta;

    public static final BlockHoneyComb[] create() {
        BlockHoneyComb[] blocks = new BlockHoneyComb[2];
        for (int i = 0; i < blocks.length; ++i) {
            HoneyCombPredicate filter = new HoneyCombPredicate(i, 16);
            final PropertyEnum variant = PropertyEnum.func_177708_a((String)"type", EnumHoneyComb.class, (Predicate)filter);
            blocks[i] = new BlockHoneyComb(filter.minMeta){

                @Override
                protected PropertyEnum<EnumHoneyComb> getVariant() {
                    return variant;
                }
            };
        }
        return blocks;
    }

    public BlockHoneyComb(int minMeta) {
        super(Material.field_151580_n);
        this.func_149711_c(1.0f);
        this.func_149647_a(Tabs.tabApiculture);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.getVariant(), (Comparable)this.getVariant().func_177700_c().iterator().next()));
        this.minMeta = minMeta;
    }

    protected abstract PropertyEnum<EnumHoneyComb> getVariant();

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant()});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumHoneyComb)((Object)state.func_177229_b(this.getVariant()))).ordinal() - this.minMeta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.getVariant(), (Comparable)((Object)EnumHoneyComb.get(this.minMeta + meta)));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumHoneyComb honeyComb : this.getVariant().func_177700_c()) {
            if (honeyComb.isSecret() && !Config.isDebug) continue;
            list.add((Object)this.get(honeyComb));
        }
    }

    public String func_149739_a() {
        return "tile.for.bee_combs";
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (EnumHoneyComb comb : this.getVariant().func_177700_c()) {
            manager.registerItemModel(item, comb.ordinal() - this.minMeta, "block_bee_combs");
        }
    }

    public ItemStack get(EnumHoneyComb honeyComb) {
        return new ItemStack((Block)this, 1, honeyComb.ordinal() - this.minMeta);
    }

    @Override
    public String getNameFromMeta(int meta) {
        EnumHoneyComb honeyComb = EnumHoneyComb.get(this.minMeta + meta);
        return honeyComb.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        int meta = this.func_176201_c(state);
        EnumHoneyComb honeyComb = EnumHoneyComb.get(this.minMeta + meta);
        if (tintIndex == 1) {
            return honeyComb.primaryColor;
        }
        return honeyComb.secondaryColor;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new HoneyCombStateMapper());
    }

    @SideOnly(value=Side.CLIENT)
    private static class HoneyCombStateMapper
    extends StateMapperBase {
        private HoneyCombStateMapper() {
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("forestry:bee_combs", "normal");
        }
    }

    private static class HoneyCombPredicate
    implements Predicate<EnumHoneyComb> {
        private final int minMeta;
        private final int maxMeta;

        public HoneyCombPredicate(int blockNumber, int variantsPerBlock) {
            this.minMeta = blockNumber * variantsPerBlock;
            this.maxMeta = this.minMeta + variantsPerBlock - 1;
        }

        public boolean apply(@Nullable EnumHoneyComb honeyComb) {
            return honeyComb != null && honeyComb.ordinal() >= this.minMeta && honeyComb.ordinal() <= this.maxMeta;
        }
    }
}

