/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail.gui;

import java.util.ArrayList;
import java.util.List;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ITradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiCatalogue extends GuiForestry<ContainerCatalogue> {

	private static final String boldUnderline = TextFormatting.BOLD.toString() + TextFormatting.UNDERLINE;

	private GuiButton buttonFilter;
	private GuiButton buttonUse;

	private final List<ItemStackWidget> tradeInfoWidgets = new ArrayList<>();

	public GuiCatalogue(EntityPlayer player) {
		super(new ResourceLocation("textures/gui/book.png"), new ContainerCatalogue(player));
		this.field_146999_f = 192;
		this.field_147000_g = 192;

		buttonFilter = new GuiButton(4, field_146294_l / 2 - 44, field_147009_r + 150, 42, 20, Translator.translateToLocal("for.gui.mail.filter.all"));
		buttonUse = new GuiButton(5, field_146294_l / 2, field_147009_r + 150, 42, 20, Translator.translateToLocal("for.gui.mail.address.copy"));
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		field_146292_n.clear();
		Keyboard.enableRepeatEvents(true);

		field_146292_n.add(new GuiButton(2, field_146294_l / 2 + 44, field_147009_r + 150, 12, 20, ">"));
		field_146292_n.add(new GuiButton(3, field_146294_l / 2 - 58, field_147009_r + 150, 12, 20, "<"));

		buttonFilter = new GuiButton(4, field_146294_l / 2 - 44, field_147009_r + 150, 42, 20, Translator.translateToLocal("for.gui.mail.filter.all"));
		field_146292_n.add(buttonFilter);

		buttonUse = new GuiButton(5, field_146294_l / 2, field_147009_r + 150, 42, 20, Translator.translateToLocal("for.gui.mail.address.copy"));
		field_146292_n.add(buttonUse);
	}

	@Override
	public void func_146281_b() {
		Keyboard.enableRepeatEvents(false);
		super.func_146281_b();
	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {
		super.func_146976_a(var1, mouseX, mouseY);

		field_146289_q.func_78276_b(String.format("%s / %s", container.getPageNumber(), container.getPageCount()), field_147003_i + field_146999_f - 72, field_147009_r + 12, ColourProperties.INSTANCE.get("gui.book"));

		clearTradeInfoWidgets();

		ITradeStationInfo tradeInfo = container.getTradeInfo();

		if (tradeInfo != null) {
			drawTradePreview(tradeInfo, field_147003_i + 38, field_147009_r + 30);
			buttonUse.field_146124_l = tradeInfo.getState().isOk();
		} else {
			drawNoTrade(field_147003_i + 38, field_147009_r + 30);
			buttonUse.field_146124_l = false;
		}

		buttonFilter.field_146126_j = Translator.translateToLocal("for.gui.mail.filter." + container.getFilterIdent());
	}

	private void drawNoTrade(int x, int y) {
		field_146289_q.func_78279_b(Translator.translateToLocal("for.gui.mail.notrades"), x, y + 18, 119, ColourProperties.INSTANCE.get("gui.book"));
	}

	private void drawTradePreview(ITradeStationInfo tradeInfo, int x, int y) {

		field_146289_q.func_78276_b(boldUnderline + tradeInfo.getAddress().getName(), x, y, ColourProperties.INSTANCE.get("gui.book"));

		field_146289_q.func_78276_b(String.format(Translator.translateToLocal("for.gui.mail.willtrade"), tradeInfo.getOwner().getName()), x, y + 18, ColourProperties.INSTANCE.get("gui.book"));

		addTradeInfoWidget(new ItemStackWidget(widgetManager, x - field_147003_i, y - field_147009_r + 28, tradeInfo.getTradegood()));

		field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.mail.tradefor"), x, y + 46, ColourProperties.INSTANCE.get("gui.book"));

		for (int i = 0; i < tradeInfo.getRequired().size(); i++) {
			ItemStack itemStack = tradeInfo.getRequired().get(i);
			addTradeInfoWidget(new ItemStackWidget(widgetManager, x - field_147003_i + i * 18, y - field_147009_r + 56, itemStack));
		}

		if (tradeInfo.getState().isOk()) {
			field_146289_q.func_78279_b(TextFormatting.DARK_GREEN + tradeInfo.getState().getDescription(), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
		} else {
			field_146289_q.func_78279_b(TextFormatting.DARK_RED + tradeInfo.getState().getDescription(), x, y + 82, 119, ColourProperties.INSTANCE.get("gui.book"));
		}
	}

	private void addTradeInfoWidget(ItemStackWidget widget) {
		tradeInfoWidgets.add(widget);
		widgetManager.add(widget);
	}

	private void clearTradeInfoWidgets() {
		for (Widget widget : tradeInfoWidgets) {
			widgetManager.remove(widget);
		}
		tradeInfoWidgets.clear();
	}

	@Override
	protected void func_146284_a(GuiButton button) {
		switch (button.field_146127_k) {
			case 0:
				field_146297_k.field_71439_g.func_71053_j();
				break;
			case 2: // next page
				NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, 0));
				break;
			case 3: // previous page
				NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, 0));
				break;
			case 4: // cycle filter
				NetworkUtil.sendToServer(new PacketGuiSelectRequest(2, 0));
				break;
			case 5:
				ITradeStationInfo info = container.getTradeInfo();
				if (info != null) {
					SessionVars.setStringVar("mail.letter.recipient", info.getAddress().getName());
					SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString());
				}
				field_146297_k.field_71439_g.func_71053_j();
				break;
		}
	}

	@Override
	protected void addLedgers() {

	}
}
