/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import javax.annotation.Nullable;

import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimatiserDefinition;
import forestry.core.climate.ClimatiserDefinition;
import forestry.greenhouse.GreenhouseClimateWindow;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileGreenhouseWindow extends TileGreenhouseClimatiser {
	@Nullable
	private WindowMode mode;
	private static final IClimatiserDefinition DEFINITION = new ClimatiserDefinition(0.001F, EnumClimatiserModes.BOTH, 5F, EnumClimatiserTypes.BOTH);

	public TileGreenhouseWindow() {
		super(DEFINITION, new GreenhouseClimateWindow(20));
	}

	public void onNeighborBlockChange() {
		WindowMode otherMode = isBlocked();
		if (getMode() != WindowMode.PLAYER && getMode() != WindowMode.CONTROL && otherMode != getMode()) {
			setMode(otherMode);
		}
	}

	public WindowMode isBlocked() {
		if (field_145850_b == null) {
			return WindowMode.BLOCK;
		}
		if (!field_145850_b.func_175667_e(field_174879_c)) {
			return WindowMode.BLOCK;
		}
		IBlockState state = field_145850_b.func_180495_p(field_174879_c);
		BlockPos blockedPos;
		if (state.func_177230_c() == PluginGreenhouse.getBlocks().getGreenhouseBlock(BlockGreenhouseType.WINDOW_UP)) {
			blockedPos = getCoordinates().func_177972_a(EnumFacing.UP);
		} else {
			blockedPos = getCoordinates().func_177972_a(state.func_177229_b(BlockGreenhouse.FACING));
		}
		return field_145850_b.func_175623_d(blockedPos) ? WindowMode.OPEN : WindowMode.BLOCK;
	}


	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		if (mode != null) {
			data.func_74777_a("mode", (short) mode.ordinal());
		}
		return super.func_189515_b(data);
	}

	@Override
	public void func_145839_a(NBTTagCompound data) {
		super.func_145839_a(data);
		if (data.func_74764_b("mode")) {
			setMode(WindowMode.values()[data.func_74765_d("mode")]);
		}
	}

	@Override
	protected void decodeDescriptionPacket(NBTTagCompound packetData) {
		super.decodeDescriptionPacket(packetData);
		if (packetData.func_74764_b("mode")) {
			setMode(WindowMode.values()[packetData.func_74765_d("mode")]);
		}
	}

	@Override
	protected void encodeDescriptionPacket(NBTTagCompound packetData) {
		if (mode != null) {
			packetData.func_74777_a("mode", (short) mode.ordinal());
		}
		super.encodeDescriptionPacket(packetData);
	}

	@Override
	public boolean canWork() {
		return true;
	}

	public void setMode(WindowMode mode) {
		this.mode = mode;
		setActive(mode == WindowMode.OPEN);
	}

	@Nullable
	public WindowMode getMode() {
		return mode;
	}

	public enum WindowMode {
		PLAYER, BLOCK, CONTROL, OPEN
	}

}
