/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.base.Preconditions;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.core.circuits.CircuitRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class SolderManager
implements ISolderManager {
    private static final List<CircuitRecipe> recipes = new ArrayList<CircuitRecipe>();

    @Override
    public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
        Preconditions.checkNotNull((Object)layout, (Object)"layout may not be null");
        Preconditions.checkNotNull((Object)resource, (Object)"resource may not be null");
        Preconditions.checkNotNull((Object)circuit, (Object)"circuit may not be null");
        recipes.add(new CircuitRecipe(layout, resource, circuit));
    }

    @Nullable
    public static ICircuit getCircuit(ICircuitLayout layout, ItemStack resource) {
        CircuitRecipe circuitRecipe = SolderManager.getMatchingRecipe(layout, resource);
        if (circuitRecipe == null) {
            return null;
        }
        return circuitRecipe.getCircuit();
    }

    @Nullable
    public static CircuitRecipe getMatchingRecipe(@Nullable ICircuitLayout layout, ItemStack resource) {
        if (layout != null) {
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
        }
        return null;
    }
}

