/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.storage;

import forestry.api.storage.IBackpackDefinition;
import forestry.core.IPickupHandler;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PickupHandlerStorage implements IPickupHandler {

	@Override
	public boolean onItemPickup(EntityPlayer player, EntityItem entityitem) {

		ItemStack itemstack = entityitem.func_92059_d();
		if (itemstack.func_190926_b()) {
			return false;
		}

		// Do not pick up if a backpack is open
		if (player.field_71070_bA instanceof ContainerBackpack || player.field_71070_bA instanceof ContainerNaturalistBackpack) {
			return false;
		}

		// Make sure to top off manually placed itemstacks in player inventory first
		topOffPlayerInventory(player, itemstack);

		for (ItemStack pack : player.field_71071_by.field_70462_a) {
			if (itemstack.func_190926_b()) {
				break;
			}

			if (pack.func_190926_b() || !(pack.func_77973_b() instanceof ItemBackpack)) {
				continue;
			}

			ItemBackpack backpack = (ItemBackpack) pack.func_77973_b();
			IBackpackDefinition backpackDefinition = backpack.getDefinition();
			if (backpackDefinition.getFilter().test(itemstack)) {
				ItemBackpack.tryStowing(player, pack, itemstack);
			}
		}

		return itemstack.func_190926_b();
	}

	/**
	 * This tops off existing stacks in the player's inventory. That way you can keep f.e. a stack of dirt or cobblestone in your inventory which gets refreshed
	 * constantly by picked up items.
	 */
	private static void topOffPlayerInventory(EntityPlayer player, ItemStack itemstack) {

		// Add to player inventory first, if there is an incomplete stack in
		// there.
		for (int i = 0; i < player.field_71071_by.func_70302_i_(); i++) {
			ItemStack inventoryStack = player.field_71071_by.func_70301_a(i);
			// We only add to existing stacks.
			if (inventoryStack.func_190926_b()) {
				continue;
			}

			// Already full
			if (inventoryStack.func_190916_E() >= inventoryStack.func_77976_d()) {
				continue;
			}

			if (inventoryStack.func_77969_a(itemstack) && ItemStack.func_77970_a(inventoryStack, itemstack)) {
				int space = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();

				if (space > itemstack.func_190916_E()) {
					// Enough space to add all
					inventoryStack.func_190917_f(itemstack.func_190916_E());
					itemstack.func_190920_e(0);
				} else {
					// Only part can be added
					inventoryStack.func_190920_e(inventoryStack.func_77976_d());
					itemstack.func_190918_g(space);
				}
			}
		}

	}

}
