/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.actuallyadditions", name="Actually Additions", author="Ellpeck", url="http://ellpeck.de/actadd", unlocalizedDescription="for.plugin.actuallyadditions.description")
public class PluginActuallyAdditions
extends BlankForestryPlugin {
    private static final String ACT_ADD = "actuallyadditions";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(ACT_ADD);
    }

    @Override
    public String getFailMessage() {
        return "Actually Additions not found!";
    }

    @Override
    public void registerRecipes() {
        Item canolaSeed = PluginActuallyAdditions.getItem("item_canola_seed");
        Item flaxSeed = PluginActuallyAdditions.getItem("item_flax_seed");
        Item riceSeed = PluginActuallyAdditions.getItem("item_rice_seed");
        Item coffeeSeed = PluginActuallyAdditions.getItem("item_coffee_seed");
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            PluginActuallyAdditions.registerSeedPlant(canolaSeed, "block_canola");
            PluginActuallyAdditions.registerSeedPlant(flaxSeed, "block_flax");
            PluginActuallyAdditions.registerSeedPlant(riceSeed, "block_rice");
            PluginActuallyAdditions.registerSeedPlant(coffeeSeed, "block_coffee");
        }
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedFluid = Fluids.SEED_OIL.getFluid(amount);
        for (Item seed : Arrays.asList(canolaSeed, flaxSeed, riceSeed, coffeeSeed)) {
            if (seed == null) continue;
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(seed), seedFluid);
        }
        Fluid canolaOil = PluginActuallyAdditions.getFluid("canolaoil");
        if (canolaOil != null) {
            Fluid oil;
            Item misc = PluginActuallyAdditions.getItem("item_misc");
            if (misc != null) {
                ItemStack canola = new ItemStack(misc, 1, 13);
                RecipeManagers.squeezerManager.addRecipe(15, canola, new FluidStack(canolaOil, 80));
            }
            if ((oil = PluginActuallyAdditions.getFluid("oil")) != null) {
                RecipeManagers.stillManager.addRecipe(200, new FluidStack(canolaOil, 5), new FluidStack(oil, 5));
            }
        }
    }

    private static void registerSeedPlant(@Nullable Item seedItem, String blockName) {
        Block plantBlock;
        if (seedItem != null && (plantBlock = PluginActuallyAdditions.getBlock(blockName)) != null) {
            FarmableAgingCrop crop = new FarmableAgingCrop(new ItemStack(seedItem), plantBlock, (IProperty<Integer>)BlockCrops.field_176488_a, 7);
            FarmRegistry.getInstance().registerFarmables("farmWheat", crop);
            FarmableAgingCrop cropOrchard = new FarmableAgingCrop(new ItemStack(seedItem), plantBlock, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0);
            FarmRegistry.getInstance().registerFarmables("farmOrchard", cropOrchard);
        }
    }

    @Nullable
    private static Fluid getFluid(String fluidName) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            Log.error("Could not find fluid {}", fluidName);
        }
        return fluid;
    }

    @Nullable
    private static Block getBlock(String blockName) {
        ResourceLocation key = new ResourceLocation(ACT_ADD, blockName);
        if (ForgeRegistries.BLOCKS.containsKey(key)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(key);
        }
        Log.error("Could not find {}", key);
        return null;
    }

    @Nullable
    private static Item getItem(String itemName) {
        ResourceLocation key = new ResourceLocation(ACT_ADD, itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return (Item)ForgeRegistries.ITEMS.getValue(key);
        }
        Log.error("Could not find {}", key);
        return null;
    }
}

