/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.IModelManager;
import forestry.core.PluginCore;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCircuitBoard
extends ItemForestry
implements IColoredItem {
    public ItemCircuitBoard() {
        this.func_77627_a(true);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]));
        subItems.add((Object)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]));
        subItems.add((Object)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
        subItems.add((Object)ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < 4; ++i) {
            manager.registerItemModel(item, i, "chipsets");
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack itemstack, int tintIndex) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.func_77952_i()];
        if (tintIndex == 0) {
            return type.getPrimaryColor();
        }
        return type.getSecondaryColor();
    }

    public String func_77667_c(ItemStack stack) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[stack.func_77952_i()];
        return "item.for.circuitboard." + type.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, player, list, flag);
        ICircuitBoard circuitboard = ChipsetManager.circuitRegistry.getCircuitBoard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static ItemStack createCircuitboard(EnumCircuitBoardType type, @Nullable ICircuitLayout layout, ICircuit[] circuits) {
        ItemStack chipset = PluginCore.getItems().circuitboards.get(type);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        new CircuitBoard(type, layout, circuits).writeToNBT(nbttagcompound);
        chipset.func_77982_d(nbttagcompound);
        return chipset;
    }

    public ItemStack get(EnumCircuitBoardType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }
}

