/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.SubCommand;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class CommandModeInfo
extends SubCommand {
    private final String[] modeStringArr;
    private final String helpString;
    private final ICommandModeHelper modeHelper;

    public CommandModeInfo(ICommandModeHelper modeHelper) {
        super("info");
        this.modeHelper = modeHelper;
        this.modeStringArr = modeHelper.getModeNames();
        this.helpString = StringUtils.join((Object[])this.modeStringArr, (String)", ");
    }

    @Override
    public void executeSubCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) {
            this.printHelp(sender);
            return;
        }
        String modeName = args[0];
        if (modeName == null) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.error", args[0]);
            this.printHelp(sender);
            return;
        }
        Style green = new Style();
        green.func_150238_a(TextFormatting.GREEN);
        CommandHelpers.sendLocalizedChatMessage(sender, green, modeName, new Object[0]);
        for (String desc : this.modeHelper.getDescription(modeName)) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for." + desc, new Object[0]);
        }
    }

    @Override
    public void printHelp(ICommandSender sender) {
        super.printHelp(sender);
        World world = sender.func_130014_f_();
        String modeName = this.modeHelper.getModeName(world);
        String worldName = String.valueOf(world.func_72912_H().func_76088_k());
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.current", modeName, worldName);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.info.available", this.helpString);
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return CommandHelpers.getListOfStringsMatchingLastWord(args, this.modeStringArr);
    }
}

