/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryCraftingForestry;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public final class MemorizedRecipe
implements INbtWritable,
INbtReadable,
IStreamable {
    private final InventoryCraftingForestry craftMatrix = new InventoryCraftingForestry();
    private NonNullList<ItemStack> recipeOutputs = NonNullList.func_191196_a();
    private int selectedRecipe;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe(PacketBufferForestry data) throws IOException {
        this.readData(data);
    }

    public MemorizedRecipe(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public MemorizedRecipe(InventoryCraftingForestry craftMatrix, NonNullList<ItemStack> recipeOutputs) {
        InventoryUtil.deepCopyInventoryContents((IInventory)craftMatrix, (IInventory)this.craftMatrix);
        this.recipeOutputs = recipeOutputs;
    }

    public InventoryCraftingForestry getCraftMatrix() {
        return this.craftMatrix;
    }

    public void calculateRecipeOutput(World world) {
        this.recipeOutputs = RecipeUtil.findMatchingRecipes(this.craftMatrix, world);
        if (this.selectedRecipe >= this.recipeOutputs.size()) {
            this.selectedRecipe = 0;
        }
        if (this.hasRecipeConflict()) {
            this.removeRecipeConflicts();
        }
    }

    public void incrementRecipe() {
        ++this.selectedRecipe;
        if (this.selectedRecipe >= this.recipeOutputs.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void decrementRecipe() {
        --this.selectedRecipe;
        if (this.selectedRecipe < 0) {
            this.selectedRecipe = this.recipeOutputs.size() - 1;
        }
    }

    public boolean hasRecipeConflict() {
        return this.recipeOutputs.size() > 1;
    }

    public void removeRecipeConflicts() {
        ItemStack recipeOutput = this.getRecipeOutput();
        this.recipeOutputs.clear();
        this.recipeOutputs.add((Object)recipeOutput);
        this.selectedRecipe = 0;
    }

    public ItemStack getRecipeOutput() {
        if (this.recipeOutputs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.recipeOutputs.get(this.selectedRecipe);
    }

    public boolean hasRecipeOutput(ItemStack output) {
        return ItemStackUtil.containsItemStack(this.recipeOutputs, output);
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.readFromNBT((IInventory)this.craftMatrix, nbttagcompound);
        this.lastUsed = nbttagcompound.func_74763_f("LastUsed");
        this.locked = nbttagcompound.func_74767_n("Locked");
        if (nbttagcompound.func_74764_b("SelectedRecipe")) {
            this.selectedRecipe = nbttagcompound.func_74762_e("SelectedRecipe");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.writeToNBT((IInventory)this.craftMatrix, nbttagcompound);
        nbttagcompound.func_74772_a("LastUsed", this.lastUsed);
        nbttagcompound.func_74757_a("Locked", this.locked);
        nbttagcompound.func_74768_a("SelectedRecipe", this.selectedRecipe);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInventory((IInventory)this.craftMatrix);
        data.writeBoolean(this.locked);
        data.writeItemStacks(this.recipeOutputs);
        data.func_150787_b(this.selectedRecipe);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        data.readInventory((IInventory)this.craftMatrix);
        this.locked = data.readBoolean();
        this.recipeOutputs = data.readItemStacks();
        this.selectedRecipe = data.func_150792_a();
    }
}

