/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.config.SessionVars;
import forestry.core.errors.FakeErrorSource;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.ledgers.ErrorLedger;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.tooltips.ToolTip;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LedgerManager {
    private final List<Ledger> ledgers = new ArrayList<Ledger>();
    private final List<ErrorLedger> errorLedgers = new ArrayList<ErrorLedger>();
    private IErrorSource errorSource;
    private int maxWidth;
    public final GuiForestry gui;

    public LedgerManager(GuiForestry gui) {
        this.gui = gui;
        this.errorSource = FakeErrorSource.instance;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void add(IErrorSource errorSource) {
        this.errorSource = errorSource;
        int maxErrorLedgerCount = (this.gui.getSizeY() - 10) / 24;
        for (int i = 0; i < maxErrorLedgerCount; ++i) {
            this.errorLedgers.add(new ErrorLedger(this));
        }
    }

    public void clear() {
        this.ledgers.clear();
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public void onGuiClosed() {
        for (Ledger ledger : this.ledgers) {
            ledger.onGuiClosed();
        }
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    @Nullable
    private Ledger getAtPosition(int mX, int mY) {
        if (!this.ledgers.isEmpty()) {
            int xShift = (this.gui.field_146294_l - this.gui.getSizeX()) / 2 + this.gui.getSizeX();
            int yShift = (this.gui.field_146295_m - this.gui.getSizeY()) / 2 + 8;
            for (Ledger ledger : this.ledgers) {
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
        }
        int xShiftError = (this.gui.field_146294_l - this.gui.getSizeX()) / 2;
        int yShiftError = (this.gui.field_146295_m - this.gui.getSizeY()) / 2 + 8;
        for (ErrorLedger errorLedger : this.errorLedgers) {
            if (!errorLedger.isVisible()) continue;
            errorLedger.currentShiftX = xShiftError - errorLedger.getWidth();
            errorLedger.currentShiftY = yShiftError;
            if (errorLedger.intersectsWith(mX, mY)) {
                return errorLedger;
            }
            yShiftError += errorLedger.getHeight();
        }
        return null;
    }

    public List<Rectangle> getLedgerAreas() {
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>();
        for (Ledger ledger : this.ledgers) {
            if (!ledger.isVisible()) continue;
            Rectangle area = ledger.getArea();
            areas.add(area);
        }
        return areas;
    }

    public void drawLedgers() {
        int yPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ledger.setPosition(this.gui.getSizeX(), yPos);
            ledger.draw();
            yPos += ledger.getHeight();
        }
        ArrayList<IErrorState> errorStates = new ArrayList<IErrorState>((Collection<IErrorState>)this.errorSource.getErrorStates());
        yPos = 8;
        int index = 0;
        for (ErrorLedger errorLedger : this.errorLedgers) {
            if (index >= errorStates.size()) {
                errorLedger.setState(null);
                continue;
            }
            IErrorState errorState = (IErrorState)errorStates.get(index++);
            errorLedger.setState(errorState);
            errorLedger.update();
            if (!errorLedger.isVisible()) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            errorLedger.draw(-errorLedger.getWidth(), yPos);
            yPos += errorLedger.getHeight();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTooltips(int mouseX, int mouseY) {
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            ToolTip toolTip = new ToolTip();
            toolTip.add(ledger.getTooltip());
            GuiUtil.drawToolTips(this.gui, toolTip, mouseX, mouseY);
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            List<Ledger> toggleLedgers = this.ledgers.contains(ledger) ? this.ledgers : this.errorLedgers;
            for (Ledger other : toggleLedgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }
}

