/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.apiculture;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IIndividualLiving;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBee
extends IIndividualLiving {
    @Override
    public IBeeGenome getGenome();

    @Override
    @Nullable
    public IBeeGenome getMate();

    public boolean isNatural();

    public int getGeneration();

    public void setIsNatural(boolean var1);

    public IEffectData[] doEffect(IEffectData[] var1, IBeeHousing var2);

    @SideOnly(value=Side.CLIENT)
    public IEffectData[] doFX(IEffectData[] var1, IBeeHousing var2);

    public boolean canSpawn();

    public Set<IErrorState> getCanWork(IBeeHousing var1);

    public List<Biome> getSuitableBiomes();

    public NonNullList<ItemStack> getProduceList();

    public NonNullList<ItemStack> getSpecialtyList();

    public NonNullList<ItemStack> produceStacks(IBeeHousing var1);

    @Nullable
    public IBee spawnPrincess(IBeeHousing var1);

    public List<IBee> spawnDrones(IBeeHousing var1);

    public void plantFlowerRandom(IBeeHousing var1);

    @Nullable
    public IIndividual retrievePollen(IBeeHousing var1);

    public boolean pollinateRandom(IBeeHousing var1, IIndividual var2);
}

