/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui.buttons;

import javax.annotation.Nullable;

import forestry.core.config.Constants;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.render.ForestryResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiBetterButton extends GuiButton implements IToolTipProvider {

	private static final ResourceLocation TEXTURE = new ForestryResource(Constants.TEXTURE_PATH_GUI + "/buttons.png");
	protected IButtonTextureSet texture;
	@Nullable
	private ToolTip toolTip;
	private boolean useTexWidth = false;

	public GuiBetterButton(int id, int x, int y, IButtonTextureSet texture) {
		super(id, x, y, texture.getWidth(), texture.getHeight(), "");
		this.texture = texture;
		useTexWidth = true;
	}

	public GuiBetterButton setTexture(IButtonTextureSet texture) {
		this.texture = texture;
		field_146120_f = texture.getWidth();
		field_146121_g = texture.getHeight();
		return this;
	}

	public GuiBetterButton setUseTextureWidth() {
		useTexWidth = true;
		return this;
	}

	public GuiBetterButton setGuiWidth(int width) {
		this.field_146120_f = width;
		useTexWidth = false;
		return this;
	}

	public GuiBetterButton setLabel(String label) {
		this.field_146126_j = label;
		return this;
	}

	public int getWidth() {
		return field_146120_f;
	}

	public int getHeight() {
		return texture.getHeight();
	}

	public int getTextColor(boolean mouseOver) {
		if (!field_146124_l) {
			return 0xffa0a0a0;
		} else if (mouseOver) {
			return 0xffffa0;
		} else {
			return 0xe0e0e0;
		}
	}

	public boolean isMouseOverButton(int mouseX, int mouseY) {
		return mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + getWidth() && mouseY < field_146129_i + getHeight();
	}

	@Override
	public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
		if (!field_146125_m) {
			return;
		}
		FontRenderer fontrenderer = minecraft.field_71466_p;
		minecraft.func_110434_K().func_110577_a(TEXTURE);
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		int xOffset = texture.getX();
		int yOffset = texture.getY();
		int h = texture.getHeight();
		int w = texture.getWidth();
		boolean mouseOver = isMouseOverButton(mouseX, mouseY);
		int hoverState = func_146114_a(mouseOver);
		if (useTexWidth) {
			func_73729_b(field_146128_h, field_146129_i, xOffset, yOffset + hoverState * h, w, h);
		} else {
			func_73729_b(field_146128_h, field_146129_i, xOffset, yOffset + hoverState * h, field_146120_f / 2, h);
			func_73729_b(field_146128_h + field_146120_f / 2, field_146129_i, xOffset + w - field_146120_f / 2, yOffset + hoverState * h, field_146120_f / 2, h);
		}
		func_146119_b(minecraft, mouseX, mouseY);
		func_73732_a(fontrenderer, field_146126_j, field_146128_h + getWidth() / 2, field_146129_i + (h - 8) / 2, getTextColor(mouseOver));
	}

	@Override
	public ToolTip getToolTip(int mouseX, int mouseY) {
		return toolTip;
	}

	public void setToolTip(ToolTip tips) {
		this.toolTip = tips;
	}

	@Override
	public boolean isToolTipVisible() {
		return field_146125_m;
	}

	@Override
	public boolean isMouseOver(int mouseX, int mouseY) {
		return isMouseOverButton(mouseX, mouseY);
	}
}
