/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture;

import com.google.common.base.Preconditions;
import forestry.api.core.CamouflageManager;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflageItemHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.arboriculture.items.ItemBlockWoodDoor;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class CamouflageHandlerArbDoor implements ICamouflageItemHandler {

	@Override
	public boolean canHandle(ItemStack stack) {
		return stack.func_77973_b() instanceof ItemBlockWoodDoor;
	}

	@Override
	public String getType() {
		return CamouflageManager.DOOR;
	}

	@Override
	public float getLightTransmittance(ItemStack stack, ICamouflageHandler camouflageHandler) {
		return 0F;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public Pair<IBlockState, IBakedModel> getModel(ItemStack stack, ICamouflageHandler camouflageHandler, ICamouflagedTile camouflageTile) {
		Preconditions.checkArgument(!stack.func_190926_b(), "Stack must not be empty");
		Preconditions.checkArgument(stack.func_77973_b() instanceof ItemBlockWoodDoor, "Item must be ItemBlockWoodDoor");

		World world = camouflageHandler.getWorldObj();
		BlockPos pos = camouflageTile.getCoordinates();
		IBlockState blockState = world.func_180495_p(pos);
		IBlockState currentState = blockState.func_185899_b(world, pos);

		ItemBlockWoodDoor itemDoor = (ItemBlockWoodDoor) stack.func_77973_b();

		IBlockState doorState = itemDoor.field_150939_a.func_176223_P()
				.func_177226_a(BlockDoor.field_176520_a, currentState.func_177229_b(BlockDoor.field_176520_a))
				.func_177226_a(BlockDoor.field_176521_M, currentState.func_177229_b(BlockDoor.field_176521_M))
				.func_177226_a(BlockDoor.field_176519_b, currentState.func_177229_b(BlockDoor.field_176519_b))
				.func_177226_a(BlockDoor.field_176522_N, currentState.func_177229_b(BlockDoor.field_176522_N))
				.func_177226_a(BlockDoor.field_176523_O, currentState.func_177229_b(BlockDoor.field_176523_O));

		BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();

		return Pair.of(doorState, modelShapes.func_178125_b(doorState));
	}

}
