/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.ForestryAPI;
import forestry.core.tiles.TileEngine;
import forestry.energy.EnergyManager;
import forestry.energy.compat.tesla.TeslaHelper;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static int scaleForDifficulty(int energyValue) {
        float energyModifier = ForestryAPI.activeMode.getFloatSetting("energy.demand.modifier");
        return Math.round((float)energyValue * energyModifier);
    }

    public static boolean consumeEnergyToDoWork(EnergyManager energyManager, int ticksPerWorkCycle, int energyPerWorkCycle) {
        if (energyPerWorkCycle == 0) {
            return true;
        }
        int energyPerCycle = (int)Math.ceil((float)energyPerWorkCycle / (float)ticksPerWorkCycle);
        if (energyManager.getEnergyStored() < energyPerCycle) {
            return false;
        }
        energyManager.drainEnergy(energyPerCycle);
        return true;
    }

    public static int sendEnergy(EnergyManager energyManager, EnumFacing orientation, @Nullable TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, false);
    }

    public static int sendEnergy(EnergyManager energyManager, EnumFacing orientation, @Nullable TileEntity tile, int amount, boolean simulate) {
        int extractable = energyManager.extractEnergy(amount, true);
        if (extractable > 0) {
            EnumFacing side = orientation.func_176734_d();
            int sent = EnergyHelper.sendEnergyToTile(tile, side, extractable, simulate);
            energyManager.extractEnergy(sent, simulate);
            return sent;
        }
        return 0;
    }

    private static int sendEnergyToTile(@Nullable TileEntity tile, EnumFacing side, int extractable, boolean simulate) {
        IEnergyStorage energyStorage;
        if (tile == null) {
            return 0;
        }
        if (tile instanceof TileEngine) {
            TileEngine receptor = (TileEngine)tile;
            return receptor.getEnergyManager().receiveEnergy(extractable, simulate);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side) && (energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)) != null) {
            return energyStorage.receiveEnergy(extractable, simulate);
        }
        if (TeslaHelper.isEnergyReceiver(tile, side)) {
            return TeslaHelper.sendEnergy(tile, side, extractable, simulate);
        }
        return 0;
    }

    public static boolean canSendEnergy(EnergyManager energyManager, EnumFacing orientation, TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, true) > 0;
    }

    public static boolean isEnergyReceiverOrEngine(EnumFacing side, @Nullable TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEngine) {
            return true;
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
            return energyStorage != null && energyStorage.canReceive();
        }
        return TeslaHelper.isEnergyReceiver(tile, side);
    }
}

