/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.core.errors.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.Translator;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.genetics.ButterflyGenome;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class Butterfly
extends IndividualLiving
implements IButterfly {
    private static final Random rand = new Random();
    private final IButterflyGenome genome;
    @Nullable
    private IButterflyGenome mate;

    public Butterfly(NBTTagCompound nbt) {
        super(nbt);
        this.genome = nbt.func_74764_b("Genome") ? new ButterflyGenome(nbt.func_74775_l("Genome")) : ButterflyManager.butterflyRoot.templateAsGenome(ButterflyManager.butterflyRoot.getDefaultTemplate());
        if (nbt.func_74764_b("Mate")) {
            this.mate = new ButterflyGenome(nbt.func_74775_l("Mate"));
        }
    }

    public Butterfly(IButterflyGenome genome) {
        super(genome.getLifespan());
        this.genome = genome;
    }

    @Override
    public void addTooltip(List<String> list) {
        IAlleleButterflySpecies primary = this.genome.getPrimary();
        IAlleleButterflySpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumButterflyChromosome.SPECIES)) {
            list.add(TextFormatting.BLUE + Translator.translateToLocal("for.butterflies.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        if (this.getMate() != null) {
            list.add(TextFormatting.RED + Translator.translateToLocal("for.gui.fecundated").toUpperCase(Locale.ENGLISH));
        }
        list.add(TextFormatting.YELLOW + this.genome.getActiveAllele(EnumButterflyChromosome.SIZE).getName());
        list.add(TextFormatting.DARK_GREEN + this.genome.getActiveAllele(EnumButterflyChromosome.SPEED).getName());
        list.add(this.genome.getActiveAllele(EnumButterflyChromosome.LIFESPAN).getName() + ' ' + Translator.translateToLocal("for.gui.life"));
        IAlleleTolerance tempTolerance = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
        list.add(TextFormatting.GREEN + "T: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + tempTolerance.getName());
        IAlleleTolerance humidTolerance = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumButterflyChromosome.HUMIDITY_TOLERANCE);
        list.add(TextFormatting.GREEN + "H: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + humidTolerance.getName());
        list.add(TextFormatting.RED + GenericRatings.rateActivityTime(this.genome.getNocturnal(), this.genome.getPrimary().isNocturnal()));
        if (this.genome.getTolerantFlyer()) {
            list.add(TextFormatting.WHITE + Translator.translateToLocal("for.gui.flyer.tooltip"));
        }
    }

    @Override
    public IButterfly copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Butterfly(nbttagcompound);
    }

    @Override
    public IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    @Nullable
    public IButterflyGenome getMate() {
        return this.mate;
    }

    @Override
    public Set<IErrorState> getCanSpawn(IButterflyNursery nursery, @Nullable IButterflyCocoon cocoon) {
        World world = nursery.getWorldObj();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        boolean isDaytime = world.func_72935_r();
        if (!this.isActiveThisTime(isDaytime)) {
            if (isDaytime) {
                errorStates.add(EnumErrorCode.NOT_NIGHT);
            } else {
                errorStates.add(EnumErrorCode.NOT_DAY);
            }
        }
        IAlleleButterflySpecies species = this.genome.getPrimary();
        EnumTemperature actualTemperature = nursery.getTemperature();
        EnumTemperature baseTemperature = species.getTemperature();
        EnumTolerance toleranceTemperature = this.genome.getToleranceTemp();
        EnumHumidity actualHumidity = nursery.getHumidity();
        EnumHumidity baseHumidity = species.getHumidity();
        EnumTolerance toleranceHumidity = this.genome.getToleranceHumid();
        ClimateUtil.addClimateErrorStates(actualTemperature, actualHumidity, baseTemperature, toleranceTemperature, baseHumidity, toleranceHumidity, errorStates);
        return errorStates;
    }

    @Override
    public Set<IErrorState> getCanGrow(IButterflyNursery nursery, @Nullable IButterflyCocoon cocoon) {
        World world = nursery.getWorldObj();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        IAlleleButterflySpecies species = this.genome.getPrimary();
        EnumTemperature actualTemperature = nursery.getTemperature();
        EnumTemperature baseTemperature = species.getTemperature();
        EnumTolerance toleranceTemperature = this.genome.getToleranceTemp();
        EnumHumidity actualHumidity = nursery.getHumidity();
        EnumHumidity baseHumidity = species.getHumidity();
        EnumTolerance toleranceHumidity = this.genome.getToleranceHumid();
        ClimateUtil.addClimateErrorStates(actualTemperature, actualHumidity, baseTemperature, toleranceTemperature, baseHumidity, toleranceHumidity, errorStates);
        return errorStates;
    }

    @Override
    public boolean canSpawn(World world, double x, double y, double z) {
        block3: {
            boolean noneMatched;
            block5: {
                Biome biome;
                block4: {
                    if (!this.canFly(world)) {
                        return false;
                    }
                    biome = world.func_180494_b(new BlockPos(x, 0.0, z));
                    if (this.getGenome().getPrimary().getSpawnBiomes().isEmpty()) break block3;
                    noneMatched = true;
                    if (!this.getGenome().getPrimary().strictSpawnMatch()) break block4;
                    Set types = BiomeDictionary.getTypes((Biome)biome);
                    if (types.size() != 1 || !this.getGenome().getPrimary().getSpawnBiomes().containsAll(types)) break block5;
                    noneMatched = false;
                    break block5;
                }
                for (BiomeDictionary.Type type : this.getGenome().getPrimary().getSpawnBiomes()) {
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return false;
            }
        }
        return this.isAcceptedEnvironment(world, x, y, z);
    }

    @Override
    public boolean canTakeFlight(World world, double x, double y, double z) {
        return this.canFly(world) && this.isAcceptedEnvironment(world, x, y, z);
    }

    private boolean canFly(World world) {
        return (!world.func_72896_J() || this.getGenome().getTolerantFlyer()) && this.isActiveThisTime(world.func_72935_r());
    }

    @Override
    public boolean isAcceptedEnvironment(World world, double x, double y, double z) {
        return this.isAcceptedEnvironment(world, (int)x, (int)y, (int)z);
    }

    private boolean isAcceptedEnvironment(World world, int x, int y, int z) {
        Biome biome = world.func_180494_b(new BlockPos(x, y, z));
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, world, new BlockPos(x, y, z));
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(ClimateUtil.getHumidity(world, new BlockPos(x, y, z)));
        return AlleleManager.climateHelper.isWithinLimits(biomeTemperature, biomeHumidity, this.getGenome().getPrimary().getTemperature(), this.getGenome().getToleranceTemp(), this.getGenome().getPrimary().getHumidity(), this.getGenome().getToleranceHumid());
    }

    @Override
    @Nullable
    public IButterfly spawnCaterpillar(World world, IButterflyNursery nursery) {
        IChromosome[] mutated2;
        if (this.mate == null) {
            return null;
        }
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Butterfly.mutateSpecies(world, nursery, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Butterfly.mutateSpecies(world, nursery, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(rand, parent1[i], parent2[i]);
        }
        return new Butterfly(new ButterflyGenome(chromosomes));
    }

    @Nullable
    private static IChromosome[] mutateSpecies(World world, IButterflyNursery nursery, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (rand.nextBoolean()) {
            allele0 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumButterflyChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumButterflyChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (IButterflyMutation mutation : ButterflyManager.butterflyRoot.getMutations(true)) {
            float chance = mutation.getChance(world, nursery, allele0, allele1, genome0, genome1);
            if (!(chance > rand.nextFloat() * 100.0f)) continue;
            return ButterflyManager.butterflyRoot.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private boolean isActiveThisTime(boolean isDayTime) {
        if (this.getGenome().getNocturnal()) {
            return true;
        }
        return isDayTime != this.getGenome().getPrimary().isNocturnal();
    }

    @Override
    public float getSize() {
        return this.getGenome().getSize();
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IButterfly)) {
            return;
        }
        this.mate = ((IButterfly)individual).getGenome();
    }

    @Override
    public NonNullList<ItemStack> getLootDrop(IEntityButterfly entity, boolean playerKill, int lootLevel) {
        NonNullList drop = NonNullList.func_191196_a();
        EntityCreature creature = entity.getEntity();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry<ItemStack, Float> entry : this.getGenome().getPrimary().getButterflyLoot().entrySet()) {
            if (!(creature.field_70170_p.field_73012_v.nextFloat() < entry.getValue().floatValue() * metabolism)) continue;
            drop.add((Object)entry.getKey().func_77946_l());
        }
        return drop;
    }

    @Override
    public NonNullList<ItemStack> getCaterpillarDrop(IButterflyNursery nursery, boolean playerKill, int lootLevel) {
        NonNullList drop = NonNullList.func_191196_a();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry<ItemStack, Float> entry : this.getGenome().getPrimary().getCaterpillarLoot().entrySet()) {
            if (!(rand.nextFloat() < entry.getValue().floatValue() * metabolism)) continue;
            drop.add((Object)entry.getKey().func_77946_l());
        }
        return drop;
    }

    @Override
    public NonNullList<ItemStack> getCocoonDrop(IButterflyCocoon cocoon) {
        NonNullList drop = NonNullList.func_191196_a();
        float metabolism = (float)this.getGenome().getMetabolism() / 10.0f;
        for (Map.Entry<ItemStack, Float> entry : this.getGenome().getCocoon().getCocoonLoot().entrySet()) {
            if (!(rand.nextFloat() < entry.getValue().floatValue() * metabolism)) continue;
            drop.add((Object)entry.getKey().func_77946_l());
        }
        if (PluginLepidopterology.getSerumChance() > 0.0f && rand.nextFloat() < PluginLepidopterology.getSerumChance() * metabolism) {
            ItemStack stack = ButterflyManager.butterflyRoot.getMemberStack(this, EnumFlutterType.SERUM);
            if (PluginLepidopterology.getSecondSerumChance() > 0.0f && rand.nextFloat() < PluginLepidopterology.getSecondSerumChance() * metabolism) {
                stack.func_190920_e(2);
            }
            drop.add((Object)ButterflyManager.butterflyRoot.getMemberStack(this, EnumFlutterType.SERUM));
        }
        if (cocoon.isSolid()) {
            drop.add((Object)ButterflyManager.butterflyRoot.getMemberStack(this, EnumFlutterType.BUTTERFLY));
        }
        return drop;
    }
}

