/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.GeneticsUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource {
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_SPECIMEN = 1;
    public static final int SLOT_ANALYZE_1 = 2;
    public static final int SLOT_ANALYZE_2 = 3;
    public static final int SLOT_ANALYZE_3 = 4;
    public static final int SLOT_ANALYZE_4 = 5;
    public static final int SLOT_ANALYZE_5 = 6;

    public ItemInventoryAlyzer(EntityPlayer player, ItemStack itemstack) {
        super(player, 7, itemstack);
    }

    public static boolean isAlyzingFuel(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            ItemRegistryApiculture beeItems = PluginApiculture.getItems();
            Item item = itemstack.func_77973_b();
            return beeItems.honeyDrop == item || beeItems.honeydew == item;
        }
        return false;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return ItemInventoryAlyzer.isAlyzingFuel(itemStack);
        }
        if (this.hasSpecimen() && this.func_70301_a(slotIndex).func_190926_b()) {
            return false;
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack));
        if (speciesRoot == null) {
            return false;
        }
        if (slotIndex == 1) {
            return true;
        }
        IIndividual individual = speciesRoot.getMember(itemStack);
        return individual != null && individual.isAnalyzed();
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        super.func_70299_a(index, itemStack);
        if (index == 1) {
            this.analyzeSpecimen(itemStack);
        }
    }

    private void analyzeSpecimen(ItemStack specimen) {
        ISpeciesRoot speciesRoot;
        if (specimen.func_190926_b()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            this.func_70299_a(1, convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) == null) {
            return;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (individual != null && !individual.isAnalyzed()) {
            boolean requiresEnergy = ForestryAPI.enabledPlugins.contains("forestry.apiculture");
            if (requiresEnergy && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                return;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                individual.writeToNBT(nbttagcompound);
                specimen.func_77982_d(nbttagcompound);
                if (requiresEnergy) {
                    this.func_70298_a(0, 1);
                }
            }
        }
        this.func_70299_a(2, specimen);
        this.func_70299_a(1, ItemStack.field_190927_a);
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.hasSpecimen()) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        } else {
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen());
            if (speciesRoot != null && !ItemInventoryAlyzer.isAlyzingFuel(this.func_70301_a(0))) {
                errorStates.add((Object)EnumErrorCode.NO_HONEY);
            }
        }
        return errorStates.build();
    }

    public ItemStack getSpecimen() {
        for (int i = 1; i <= 6; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasSpecimen() {
        return !this.getSpecimen().func_190926_b();
    }
}

