/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;

public class PowerLedger
extends Ledger {
    private final EnergyManager energyManager;

    public PowerLedger(LedgerManager manager, EnergyManager energyManager) {
        super(manager, "power");
        this.energyManager = energyManager;
        this.maxHeight = 94;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawSprite(TextureManagerForestry.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        int xHeader = x + 22;
        int xBody = x + 12;
        this.drawHeader(Translator.translateToLocal("for.gui.energy"), xHeader, y + 8);
        this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', xBody, y + 20);
        this.drawText(this.energyManager.getEnergyStored() + " RF", xBody, y + 32);
        this.drawSubheader(Translator.translateToLocal("for.gui.maxenergy") + ':', xBody, y + 44);
        this.drawText(this.energyManager.getMaxEnergyStored() + " RF", xBody, y + 56);
        this.drawSubheader(Translator.translateToLocal("for.gui.maxenergyreceive") + ':', xBody, y + 68);
        this.drawText(this.energyManager.getMaxEnergyReceived() + " RF", xBody, y + 80);
    }

    @Override
    public String getTooltip() {
        return this.energyManager.getEnergyStored() + " RF";
    }
}

