/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.core.IStateMapperRegister;
import forestry.api.genetics.AlleleRegisterEvent;
import forestry.arboriculture.blocks.BlockArbDoor;
import forestry.arboriculture.blocks.BlockArbFence;
import forestry.arboriculture.blocks.BlockArbLog;
import forestry.arboriculture.blocks.BlockArbPlanks;
import forestry.arboriculture.blocks.BlockArbSlab;
import forestry.arboriculture.blocks.BlockArboriculture;
import forestry.arboriculture.blocks.BlockCharcoal;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockFireproofVanillaFence;
import forestry.arboriculture.blocks.BlockFireproofVanillaLog;
import forestry.arboriculture.blocks.BlockFireproofVanillaPlanks;
import forestry.arboriculture.blocks.BlockFireproofVanillaSlab;
import forestry.arboriculture.blocks.BlockForestryFence;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.blocks.BlockForestrySlab;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.BlockLoam;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.blocks.BlockTypeArboricultureTesr;
import forestry.arboriculture.blocks.BlockWoodPile;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.items.ItemBlockDecorativeLeaves;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.items.ItemBlockWoodDoor;
import forestry.arboriculture.items.ItemBlockWoodSlab;
import forestry.core.blocks.BlockRegistry;
import forestry.core.items.ItemBlockForestry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class BlockRegistryArboriculture
extends BlockRegistry {
    public final List<BlockArbLog> logs = BlockArbLog.create(false);
    public final List<BlockArbLog> logsFireproof;
    public final List<BlockFireproofVanillaLog> logsVanillaFireproof;
    public final List<BlockArbPlanks> planks;
    public final List<BlockArbPlanks> planksFireproof;
    public final List<BlockFireproofVanillaPlanks> planksVanillaFireproof;
    public final List<BlockArbSlab> slabs;
    public final List<BlockArbSlab> slabsDouble;
    public final List<BlockArbSlab> slabsFireproof;
    public final List<BlockArbSlab> slabsDoubleFireproof;
    public final List<BlockFireproofVanillaSlab> slabsVanillaFireproof;
    public final List<BlockFireproofVanillaSlab> slabsVanillaDoubleFireproof;
    public final List<BlockArbFence> fences;
    public final List<BlockArbFence> fencesFireproof;
    public final List<BlockFireproofVanillaFence> fencesVanillaFireproof;
    public final List<BlockForestryFenceGate> fenceGates;
    public final List<BlockForestryFenceGate> fenceGatesFireproof;
    public final List<BlockForestryFenceGate> fenceGatesVanillaFireproof;
    public final List<BlockForestryStairs> stairs;
    public final List<BlockForestryStairs> stairsFireproof;
    public final List<BlockForestryStairs> stairsVanillaFireproof;
    public final List<BlockArbDoor> doors;
    public final BlockSapling saplingGE;
    public final BlockForestryLeaves leaves;
    public final List<BlockDecorativeLeaves> leavesDecorative;
    private final Map<String, ItemStack> speciesToLeavesDecorative;
    public final Map<String, BlockFruitPod> podsMap;
    public final BlockCharcoal charcoal;
    public final BlockWoodPile woodPile;
    public final Block loam;
    public final BlockArboriculture treeChest;

    public BlockRegistryArboriculture() {
        BlockForestryStairs<EnumForestryWoodType> stair;
        Enum woodType;
        BlockForestrySlab slabDouble;
        int i;
        for (BlockArbLog blockArbLog : this.logs) {
            this.registerBlock(blockArbLog, new ItemBlockWood((Block)blockArbLog), "logs." + blockArbLog.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("logWood", (Block)blockArbLog);
        }
        this.logsFireproof = BlockArbLog.create(true);
        for (BlockArbLog blockArbLog : this.logsFireproof) {
            this.registerBlock(blockArbLog, new ItemBlockWood((Block)blockArbLog), "logs.fireproof." + blockArbLog.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("logWood", (Block)blockArbLog);
        }
        this.logsVanillaFireproof = BlockFireproofVanillaLog.create();
        for (BlockFireproofVanillaLog blockFireproofVanillaLog : this.logsVanillaFireproof) {
            this.registerBlock(blockFireproofVanillaLog, new ItemBlockWood((Block)blockFireproofVanillaLog), "logs.vanilla.fireproof." + blockFireproofVanillaLog.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("logWood", (Block)blockFireproofVanillaLog);
        }
        this.planks = BlockArbPlanks.create(false);
        for (BlockArbPlanks blockArbPlanks : this.planks) {
            this.registerBlock(blockArbPlanks, new ItemBlockWood(blockArbPlanks), "planks." + blockArbPlanks.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("plankWood", blockArbPlanks);
        }
        this.planksFireproof = BlockArbPlanks.create(true);
        for (BlockArbPlanks blockArbPlanks : this.planksFireproof) {
            this.registerBlock(blockArbPlanks, new ItemBlockWood(blockArbPlanks), "planks.fireproof." + blockArbPlanks.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("plankWood", blockArbPlanks);
        }
        this.planksVanillaFireproof = BlockFireproofVanillaPlanks.create();
        for (BlockFireproofVanillaPlanks blockFireproofVanillaPlanks : this.planksVanillaFireproof) {
            this.registerBlock(blockFireproofVanillaPlanks, new ItemBlockWood(blockFireproofVanillaPlanks), "planks.vanilla.fireproof." + blockFireproofVanillaPlanks.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("plankWood", blockFireproofVanillaPlanks);
        }
        this.slabs = BlockArbSlab.create(false, false);
        this.slabsDouble = BlockArbSlab.create(false, true);
        for (i = 0; i < this.slabs.size(); ++i) {
            BlockArbSlab blockArbSlab = this.slabs.get(i);
            slabDouble = this.slabsDouble.get(i);
            this.registerBlock(blockArbSlab, (ItemBlock)new ItemBlockWoodSlab(blockArbSlab, blockArbSlab, slabDouble), "slabs." + blockArbSlab.getBlockNumber());
            this.registerBlock(slabDouble, (ItemBlock)new ItemBlockWoodSlab(slabDouble, blockArbSlab, slabDouble), "slabs.double." + slabDouble.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("slabWood", (Block)blockArbSlab);
        }
        this.slabsFireproof = BlockArbSlab.create(true, false);
        this.slabsDoubleFireproof = BlockArbSlab.create(true, true);
        for (i = 0; i < this.slabsFireproof.size(); ++i) {
            BlockArbSlab blockArbSlab = this.slabsFireproof.get(i);
            slabDouble = this.slabsDoubleFireproof.get(i);
            this.registerBlock(blockArbSlab, (ItemBlock)new ItemBlockWoodSlab(blockArbSlab, blockArbSlab, slabDouble), "slabs.fireproof." + blockArbSlab.getBlockNumber());
            this.registerBlock(slabDouble, (ItemBlock)new ItemBlockWoodSlab(slabDouble, blockArbSlab, slabDouble), "slabs.double.fireproof." + slabDouble.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("slabWood", (Block)blockArbSlab);
        }
        this.slabsVanillaFireproof = BlockFireproofVanillaSlab.create(false);
        this.slabsVanillaDoubleFireproof = BlockFireproofVanillaSlab.create(true);
        for (i = 0; i < this.slabsVanillaFireproof.size(); ++i) {
            BlockForestrySlab blockForestrySlab = this.slabsVanillaFireproof.get(i);
            slabDouble = this.slabsVanillaDoubleFireproof.get(i);
            this.registerBlock(blockForestrySlab, (ItemBlock)new ItemBlockWoodSlab(blockForestrySlab, blockForestrySlab, slabDouble), "slabs.vanilla.fireproof." + blockForestrySlab.getBlockNumber());
            this.registerBlock(slabDouble, (ItemBlock)new ItemBlockWoodSlab(slabDouble, blockForestrySlab, slabDouble), "slabs.vanilla.double.fireproof." + slabDouble.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("slabWood", (Block)blockForestrySlab);
        }
        this.fences = BlockArbFence.create(false);
        for (BlockArbFence blockArbFence : this.fences) {
            this.registerBlock(blockArbFence, new ItemBlockWood((Block)blockArbFence), "fences." + blockArbFence.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("fenceWood", (Block)blockArbFence);
        }
        this.fencesFireproof = BlockArbFence.create(true);
        for (BlockArbFence blockArbFence : this.fencesFireproof) {
            this.registerBlock(blockArbFence, new ItemBlockWood((Block)blockArbFence), "fences.fireproof." + blockArbFence.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("fenceWood", (Block)blockArbFence);
        }
        this.fencesVanillaFireproof = BlockFireproofVanillaFence.create();
        for (BlockFireproofVanillaFence blockFireproofVanillaFence : this.fencesVanillaFireproof) {
            this.registerBlock(blockFireproofVanillaFence, new ItemBlockWood((Block)blockFireproofVanillaFence), "fences.vanilla.fireproof." + blockFireproofVanillaFence.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("fenceWood", (Block)blockFireproofVanillaFence);
        }
        this.fenceGates = new ArrayList<BlockForestryFenceGate>();
        this.fenceGatesFireproof = new ArrayList<BlockForestryFenceGate>();
        for (Iterator<BlockForestryFence> iterator : EnumForestryWoodType.VALUES) {
            BlockForestryFenceGate<Iterator<BlockForestryFence>> fenceGate = new BlockForestryFenceGate<Iterator<BlockForestryFence>>(false, iterator);
            this.registerBlock(fenceGate, new ItemBlockWood((Block)fenceGate), "fence.gates." + iterator);
            BlockRegistryArboriculture.registerOreDictWildcard("fenceGateWood", fenceGate);
            this.fenceGates.add(fenceGate);
            BlockForestryFenceGate<Iterator<BlockForestryFence>> fenceGateFireproof = new BlockForestryFenceGate<Iterator<BlockForestryFence>>(true, iterator);
            this.registerBlock(fenceGateFireproof, new ItemBlockWood((Block)fenceGateFireproof), "fence.gates.fireproof." + iterator);
            BlockRegistryArboriculture.registerOreDictWildcard("fenceGateWood", fenceGateFireproof);
            this.fenceGatesFireproof.add(fenceGateFireproof);
        }
        this.fenceGatesVanillaFireproof = new ArrayList<BlockForestryFenceGate>();
        for (Iterator<BlockForestryFence> iterator : EnumVanillaWoodType.VALUES) {
            BlockForestryFenceGate<Iterator<BlockForestryFence>> fenceGateFireproof = new BlockForestryFenceGate<Iterator<BlockForestryFence>>(true, iterator);
            this.registerBlock(fenceGateFireproof, new ItemBlockWood((Block)fenceGateFireproof), "fence.gates.vanilla.fireproof." + iterator);
            BlockRegistryArboriculture.registerOreDictWildcard("fenceGateWood", fenceGateFireproof);
            this.fenceGatesFireproof.add(fenceGateFireproof);
        }
        this.stairs = new ArrayList<BlockForestryStairs>();
        for (BlockArbPlanks blockArbPlanks : this.planks) {
            for (IBlockState iBlockState : blockArbPlanks.func_176194_O().func_177619_a()) {
                int meta = blockArbPlanks.func_176201_c(iBlockState);
                woodType = blockArbPlanks.getWoodType(meta);
                stair = new BlockForestryStairs<EnumForestryWoodType>(false, iBlockState, (EnumForestryWoodType)woodType);
                this.registerBlock(stair, new ItemBlockWood((Block)stair), "stairs." + woodType);
                BlockRegistryArboriculture.registerOreDictWildcard("stairWood", stair);
                this.stairs.add(stair);
            }
        }
        this.stairsFireproof = new ArrayList<BlockForestryStairs>();
        for (BlockArbPlanks blockArbPlanks : this.planksFireproof) {
            for (IBlockState iBlockState : blockArbPlanks.func_176194_O().func_177619_a()) {
                int meta = blockArbPlanks.func_176201_c(iBlockState);
                woodType = blockArbPlanks.getWoodType(meta);
                stair = new BlockForestryStairs<EnumForestryWoodType>(true, iBlockState, (EnumForestryWoodType)woodType);
                this.registerBlock(stair, new ItemBlockWood((Block)stair), "stairs.fireproof." + woodType);
                BlockRegistryArboriculture.registerOreDictWildcard("stairWood", stair);
                this.stairsFireproof.add(stair);
            }
        }
        this.stairsVanillaFireproof = new ArrayList<BlockForestryStairs>();
        for (BlockFireproofVanillaPlanks blockFireproofVanillaPlanks : this.planksVanillaFireproof) {
            for (IBlockState iBlockState : blockFireproofVanillaPlanks.func_176194_O().func_177619_a()) {
                int meta = blockFireproofVanillaPlanks.func_176201_c(iBlockState);
                woodType = blockFireproofVanillaPlanks.getWoodType(meta);
                stair = new BlockForestryStairs<EnumForestryWoodType>(true, iBlockState, (EnumForestryWoodType)woodType);
                this.registerBlock(stair, new ItemBlockWood((Block)stair), "stairs.vanilla.fireproof." + woodType);
                BlockRegistryArboriculture.registerOreDictWildcard("stairWood", stair);
                this.stairsVanillaFireproof.add(stair);
            }
        }
        this.doors = new ArrayList<BlockArbDoor>();
        for (Iterator<IStateMapperRegister> iterator : EnumForestryWoodType.VALUES) {
            BlockArbDoor door = new BlockArbDoor((EnumForestryWoodType)((Object)iterator));
            this.registerBlock(door, new ItemBlockWoodDoor((Block)door), "doors." + iterator);
            BlockRegistryArboriculture.registerOreDictWildcard("doorWood", (Block)door);
            this.doors.add(door);
        }
        TreeDefinition.preInit();
        this.saplingGE = new BlockSapling();
        this.registerBlock(this.saplingGE, new ItemBlockForestry((Block)this.saplingGE), "sapling_ge");
        BlockRegistryArboriculture.registerOreDictWildcard("treeSapling", (Block)this.saplingGE);
        this.leaves = new BlockForestryLeaves();
        this.registerBlock(this.leaves, new ItemBlockLeaves((Block)this.leaves), "leaves");
        BlockRegistryArboriculture.registerOreDictWildcard("treeLeaves", (Block)this.leaves);
        this.leavesDecorative = BlockDecorativeLeaves.create();
        this.speciesToLeavesDecorative = new HashMap<String, ItemStack>();
        for (BlockDecorativeLeaves blockDecorativeLeaves : this.leavesDecorative) {
            this.registerBlock(blockDecorativeLeaves, new ItemBlockDecorativeLeaves(blockDecorativeLeaves), "leaves.decorative." + blockDecorativeLeaves.getBlockNumber());
            BlockRegistryArboriculture.registerOreDictWildcard("treeLeaves", blockDecorativeLeaves);
            for (IBlockState iBlockState : blockDecorativeLeaves.func_176194_O().func_177619_a()) {
                TreeDefinition treeDefinition = (TreeDefinition)((Object)iBlockState.func_177229_b((IProperty)blockDecorativeLeaves.getVariant()));
                String speciesUid = treeDefinition.getUID();
                int meta = blockDecorativeLeaves.func_176201_c(iBlockState);
                this.speciesToLeavesDecorative.put(speciesUid, new ItemStack((Block)blockDecorativeLeaves, 1, meta));
            }
        }
        this.charcoal = new BlockCharcoal();
        this.registerBlock(this.charcoal, new ItemBlockForestry(this.charcoal), "charcoal");
        this.woodPile = new BlockWoodPile();
        this.registerBlock(this.woodPile, new ItemBlockForestry(this.woodPile), "wood_pile");
        this.loam = new BlockLoam();
        this.registerBlock(this.loam, new ItemBlockForestry(this.loam), "loam");
        AlleleFruits.registerAlleles();
        MinecraftForge.EVENT_BUS.post(new AlleleRegisterEvent<IAlleleFruit>(IAlleleFruit.class));
        this.podsMap = new HashMap<String, BlockFruitPod>();
        for (BlockFruitPod blockFruitPod : BlockFruitPod.create()) {
            IAlleleFruit fruit = blockFruitPod.getFruit();
            this.registerBlock(blockFruitPod, "pods." + fruit.getModelName());
            this.podsMap.put(fruit.getUID(), blockFruitPod);
        }
        this.treeChest = new BlockArboriculture(BlockTypeArboricultureTesr.ARB_CHEST);
        this.registerBlock(this.treeChest, new ItemBlockForestry(this.treeChest), "tree_chest");
    }

    public ItemStack getDecorativeLeaves(String speciesUid) {
        ItemStack itemStack = this.speciesToLeavesDecorative.get(speciesUid);
        if (itemStack == null) {
            return ItemStack.field_190927_a;
        }
        return itemStack.func_77946_l();
    }

    @Nullable
    public BlockFruitPod getFruitPod(IAlleleFruit fruit) {
        return this.podsMap.get(fruit.getUID());
    }
}

