/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.gui.IGuiSelectable;
import forestry.core.utils.NetworkUtil;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.network.packets.PacketLetterInfoResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;

public class ContainerCatalogue
extends Container
implements IGuiSelectable,
ILetterInfoReceiver {
    private final EntityPlayer player;
    private final List<ITradeStation> stations = new ArrayList<ITradeStation>();
    @Nullable
    private ITradeStationInfo currentTrade = null;
    private int stationIndex = 0;
    private int stationCount;
    private boolean needsSync = true;
    private int currentFilter = 1;
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final List<Set<IPostalState>> FILTERS = new ArrayList<Set<IPostalState>>();

    public ContainerCatalogue(EntityPlayer player) {
        this.player = player;
        if (!player.field_70170_p.field_72995_K) {
            this.rebuildStationsList();
        }
    }

    public int getPageCount() {
        return Math.max(this.stationCount, 1);
    }

    public int getPageNumber() {
        return this.stationIndex + 1;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter];
    }

    private void rebuildStationsList() {
        this.stations.clear();
        IPostOffice postOffice = PostManager.postRegistry.getPostOffice(this.player.field_70170_p);
        Map<IMailAddress, ITradeStation> tradeStations = postOffice.getActiveTradeStations(this.player.field_70170_p);
        for (ITradeStation station : tradeStations.values()) {
            ITradeStationInfo info = station.getTradeInfo();
            if (!FILTERS.get(this.currentFilter).contains(info.getState())) continue;
            this.stations.add(station);
        }
        this.stationIndex = 0;
        this.updateTradeInfo();
    }

    public void nextPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex = (this.stationIndex + 1) % this.stations.size();
            this.updateTradeInfo();
        }
    }

    public void previousPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex = (this.stationIndex - 1 + this.stations.size()) % this.stations.size();
            this.updateTradeInfo();
        }
    }

    public void cycleFilter() {
        this.currentFilter = (this.currentFilter + 1) % FILTERS.size();
        this.rebuildStationsList();
    }

    private void updateTradeInfo() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.stations.isEmpty()) {
            ITradeStation station = this.stations.get(this.stationIndex);
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSync = true;
    }

    @Override
    public void handleLetterInfoUpdate(EnumAddressee type, @Nullable IMailAddress address, @Nullable ITradeStationInfo tradeInfo) {
        this.setTradeInfo(tradeInfo);
    }

    @Nullable
    public ITradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(@Nullable ITradeStationInfo info) {
        this.currentTrade = info;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.needsSync) {
            for (IContainerListener crafter : this.field_75149_d) {
                crafter.func_71112_a((Container)this, 0, this.stationIndex);
                crafter.func_71112_a((Container)this, 1, this.stations.size());
                crafter.func_71112_a((Container)this, 2, this.currentFilter);
            }
            NetworkUtil.sendToPlayer(new PacketLetterInfoResponse(EnumAddressee.TRADER, this.currentTrade, null), this.player);
            this.needsSync = false;
        }
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.stationIndex = j;
                break;
            }
            case 1: {
                this.stationCount = j;
                break;
            }
            case 2: {
                this.currentFilter = j;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, int primary, int secondary) {
        switch (primary) {
            case 0: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
                break;
            }
            case 2: {
                this.cycleFilter();
            }
        }
        this.needsSync = true;
    }

    static {
        EnumSet<EnumTradeStationState> all = EnumSet.allOf(EnumTradeStationState.class);
        EnumSet<EnumTradeStationState> online = EnumSet.of(EnumTradeStationState.OK);
        EnumSet<EnumTradeStationState> offline = EnumSet.copyOf(all);
        offline.removeAll(online);
        FILTERS.add(Collections.unmodifiableSet(all));
        FILTERS.add(Collections.unmodifiableSet(online));
        FILTERS.add(Collections.unmodifiableSet(offline));
    }
}

