package forestry.plugins.compat;

import forestry.api.core.ForestryAPI;
import forestry.core.config.Constants;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.ForestryPluginUids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@ForestryPlugin(pluginID = ForestryPluginUids.ENDER_IO, name = "EnderIO", author = "mezz", url = Constants.URL, unlocalizedDescription = "for.plugin.enderIO.description")
public class PluginEnderIO extends BlankForestryPlugin {

	private static final String EnderIO = "EnderIO";

	private static final String FLUID_FUEL_ADD = "fluidFuel:add";
	private static final String FLUID_COOLANT_ADD = "fluidCoolant:add";

	private static final String KEY_FLUID_NAME = "fluidName";
	private static final String KEY_POWER_PER_CYCLE = "powerPerCycle";
	private static final String KEY_TOTAL_BURN_TIME = "totalBurnTime";
	private static final String KEY_COOLING_PER_MB = "coolingPerMb";

	private static final float WATER_COOLING_PER_MB = 0.0023f;

	@Override
	public boolean isAvailable() {
		return ModUtil.isModLoaded(EnderIO);
	}

	@Override
	public String getFailMessage() {
		return "EnderIO not found";
	}

	@Override
	public void doInit() {
		Fluid ethanol = Fluids.BIO_ETHANOL.getFluid();
		if (ethanol != null) {
			int ethanolBurnTime = Math.round(Constants.ENGINE_CYCLE_DURATION_ETHANOL * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.combustion"));
			addFuel(ethanol, 40, ethanolBurnTime);
		}

		Fluid crushedIce = Fluids.ICE.getFluid();
		if (crushedIce != null) {
			addCoolant(crushedIce, Constants.ICE_COOLING_MULTIPLIER);
		}
	}

	private static void addFuel(Fluid fluid, int powerPerCycle, int totalBurnTime) {
		NBTTagCompound fuelTag = new NBTTagCompound();
		fuelTag.func_74778_a(KEY_FLUID_NAME, fluid.getName());
		fuelTag.func_74768_a(KEY_POWER_PER_CYCLE, powerPerCycle);
		fuelTag.func_74768_a(KEY_TOTAL_BURN_TIME, totalBurnTime);

		FMLInterModComms.sendMessage(EnderIO, FLUID_FUEL_ADD, fuelTag);
	}

	private static void addCoolant(Fluid fluid, float coolingMultiplier) {
		float coolingPerMb = coolingMultiplier * WATER_COOLING_PER_MB;
		NBTTagCompound coolantTag = new NBTTagCompound();
		coolantTag.func_74778_a(KEY_FLUID_NAME, fluid.getName());
		coolantTag.func_74776_a(KEY_COOLING_PER_MB, coolingPerMb);

		FMLInterModComms.sendMessage(EnderIO, FLUID_COOLANT_ADD, coolantTag);
	}
}
