/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileUtil;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketRecipeTransferUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final NonNullList<ItemStack> craftingInventory;

    public PacketRecipeTransferUpdate(TileBase base, NonNullList<ItemStack> craftingInventory) {
        this.pos = base.func_174877_v();
        this.craftingInventory = craftingInventory;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        data.writeItemStacks(this.craftingInventory);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.RECIPE_TRANSFER_UPDATE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            block3: {
                TileEntity tile;
                NonNullList<ItemStack> craftingInventory;
                block2: {
                    BlockPos pos = data.func_179259_c();
                    craftingInventory = data.readItemStacks();
                    tile = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos);
                    if (!(tile instanceof TileCarpenter)) break block2;
                    TileCarpenter carpenter = (TileCarpenter)tile;
                    int index = 0;
                    for (ItemStack stack : craftingInventory) {
                        carpenter.getCraftingInventory().func_70299_a(index, stack);
                        ++index;
                    }
                    break block3;
                }
                if (!(tile instanceof TileFabricator)) break block3;
                TileFabricator fabricator = (TileFabricator)tile;
                int index = 0;
                for (ItemStack stack : craftingInventory) {
                    fabricator.getCraftingInventory().func_70299_a(index, stack);
                    ++index;
                }
            }
        }
    }
}

