/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.loot;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import forestry.core.utils.Log;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;

public class LootTableLoader {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    @Nullable
    public static LootTable loadBuiltinLootTable(ResourceLocation resource) {
        URL url = LootTableLoader.class.getResource("/assets/" + resource.func_110624_b() + "/loot_tables/" + resource.func_110623_a() + ".json");
        if (url != null) {
            String s;
            try {
                s = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            }
            catch (IOException ioexception) {
                Log.warning("Couldn't load loot table " + resource + " from " + url, ioexception);
                return LootTable.field_186464_a;
            }
            try {
                return ForgeHooks.loadLootTable((Gson)GSON_INSTANCE, (ResourceLocation)resource, (String)s, (boolean)false);
            }
            catch (JsonParseException jsonparseexception) {
                Log.error("Couldn't load loot table " + resource + " from " + url, new Object[]{jsonparseexception});
                return LootTable.field_186464_a;
            }
        }
        return null;
    }
}

