/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IToolScoop;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyGoHome;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.entities.EnumButterflyState;
import forestry.lepidopterology.genetics.Butterfly;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityButterfly
extends EntityCreature
implements IEntityButterfly {
    public static final int COOLDOWNS = 1500;
    private static final DataParameter<String> DATAWATCHER_ID_SPECIES = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DATAWATCHER_ID_SIZE = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> DATAWATCHER_ID_STATE = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final float DEFAULT_BUTTERFLY_SIZE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    public static final int MAX_LIFESPAN = 168000;
    @Nullable
    private Vec3d flightTarget;
    private int exhaustion;
    private IButterfly contained = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
    @Nullable
    private IIndividual pollen;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    public int cooldownMate = 0;
    @Nullable
    private IAlleleButterflySpecies species;
    private float size = 0.75f;
    private EnumButterflyState state = DEFAULT_STATE;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation textureResource;

    public EntityButterfly(World world) {
        super(world);
        this.setDefaults();
    }

    public EntityButterfly(World world, IButterfly butterfly, BlockPos homePos) {
        super(world);
        this.setDefaults();
        this.setIndividual(butterfly);
        this.func_175449_a(homePos, PluginLepidopterology.maxDistance);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_SPECIES, (Object)"");
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_SIZE, (Object)75);
        this.field_70180_af.func_187214_a(DATAWATCHER_ID_STATE, (Object)((byte)DEFAULT_STATE.ordinal()));
    }

    private void setDefaults() {
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIButterflyFlee(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIButterflyMate(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIButterflyPollinate(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AIButterflyRest(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIButterflyRise(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIButterflyWander(this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new AIButterflyGoHome(this));
    }

    @Override
    public EntityCreature getEntity() {
        return this;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        NBTTagCompound bio = new NBTTagCompound();
        this.contained.writeToNBT(bio);
        nbttagcompound.func_74782_a("BTFLY", (NBTBase)bio);
        if (this.pollen != null) {
            NBTTagCompound pln = new NBTTagCompound();
            pln.func_74778_a("Root", this.pollen.getGenome().getSpeciesRoot().getUID());
            this.pollen.writeToNBT(pln);
            nbttagcompound.func_74782_a("PLN", (NBTBase)pln);
        }
        nbttagcompound.func_74774_a("STATE", (byte)this.getState().ordinal());
        nbttagcompound.func_74768_a("EXH", this.exhaustion);
        nbttagcompound.func_74768_a("homeX", this.func_180486_cf().func_177958_n());
        nbttagcompound.func_74768_a("homeY", this.func_180486_cf().func_177956_o());
        nbttagcompound.func_74768_a("homeZ", this.func_180486_cf().func_177952_p());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        Butterfly butterfly = null;
        if (nbttagcompound.func_74764_b("BTFLY")) {
            butterfly = new Butterfly((NBTTagCompound)nbttagcompound.func_74781_a("BTFLY"));
        }
        this.setIndividual(butterfly);
        if (nbttagcompound.func_74764_b("PLN")) {
            NBTTagCompound pollenNBT = nbttagcompound.func_74775_l("PLN");
            ISpeciesRoot root = pollenNBT.func_74764_b("PLN") ? AlleleManager.alleleRegistry.getSpeciesRoot(pollenNBT.func_74779_i("Root")) : TreeManager.treeRoot;
            this.pollen = root.getMember(pollenNBT);
        }
        EnumButterflyState state = EnumButterflyState.VALUES[nbttagcompound.func_74771_c("STATE")];
        this.setState(state);
        this.exhaustion = nbttagcompound.func_74762_e("EXH");
        BlockPos home = new BlockPos(nbttagcompound.func_74762_e("homeX"), nbttagcompound.func_74762_e("homeY"), nbttagcompound.func_74762_e("homeZ"));
        this.func_175449_a(home, PluginLepidopterology.maxDistance);
    }

    public float getWingFlap(float partialTicktime) {
        int offset = this.species != null ? this.species.getUID().hashCode() : this.field_70170_p.field_73012_v.nextInt();
        return this.getState().getWingFlap(this, offset, partialTicktime);
    }

    public void setState(EnumButterflyState state) {
        if (this.state != state) {
            this.state = state;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(DATAWATCHER_ID_STATE, (Object)((byte)state.ordinal()));
            }
        }
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.contained.getGenome().getSpeed();
    }

    @Nullable
    public Vec3d getDestination() {
        return this.flightTarget;
    }

    public void setDestination(@Nullable Vec3d destination) {
        this.flightTarget = destination;
    }

    public float func_180484_a(BlockPos pos) {
        int depth;
        if (!this.field_70170_p.func_175667_e(pos)) {
            return -100.0f;
        }
        float weight = 0.0f;
        if (!this.getButterfly().isAcceptedEnvironment(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            weight -= 15.0f;
        }
        if (!this.field_70170_p.func_72872_a(EntityButterfly.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(pos)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            IBlockState blockState = this.field_70170_p.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block instanceof BlockFlower) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof IGrowable) {
                weight += 1.0f;
            } else if (blockState.func_185904_a() == Material.field_151585_k) {
                weight += 1.0f;
            }
            BlockPos posBelow = pos.func_177977_b();
            IBlockState blockStateBelow = this.field_70170_p.func_180495_p(posBelow);
            Block blockBelow = blockStateBelow.func_177230_c();
            if (blockBelow.isLeaves(blockStateBelow, (IBlockAccess)this.field_70170_p, posBelow)) {
                weight += 2.5f;
            } else if (blockBelow instanceof BlockFence) {
                weight += 1.0f;
            } else if (blockBelow instanceof BlockWall) {
                weight += 1.0f;
            }
        }
        return weight += this.field_70170_p.func_175724_o(pos);
    }

    private int getFluidDepth(BlockPos pos) {
        Chunk chunk = this.field_70170_p.func_175726_f(pos);
        int xx = pos.func_177958_n() & 0xF;
        int zz = pos.func_177952_p() & 0xF;
        int depth = 0;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            IBlockState blockState = chunk.func_186032_a(xx, y, zz);
            Block block = blockState.func_177230_c();
            if (blockState.func_185904_a().func_76224_d()) {
                ++depth;
                continue;
            }
            if (!block.isAir(blockState, (IBlockAccess)this.field_70170_p, pos)) break;
        }
        return depth;
    }

    @Override
    @Nullable
    public IIndividual getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(@Nullable IIndividual pollen) {
        this.pollen = pollen;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = this.exhaustion + change > 0 ? this.exhaustion + change : 0;
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void setIndividual(@Nullable IButterfly butterfly) {
        if (butterfly == null) {
            butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
        }
        this.contained = butterfly;
        IButterflyGenome genome = this.contained.getGenome();
        this.field_70178_ae = genome.getFireResist();
        this.size = genome.getSize();
        this.func_70105_a(this.size, 0.4f);
        this.species = genome.getPrimary();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(DATAWATCHER_ID_SIZE, (Object)((int)(this.size * 100.0f)));
            this.field_70180_af.func_187227_b(DATAWATCHER_ID_SPECIES, (Object)this.species.getUID());
        } else {
            this.textureResource = new ResourceLocation(this.species.getEntityTexture());
        }
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.setIndividual(this.contained);
        }
        return data;
    }

    public String func_70005_c_() {
        if (this.species == null) {
            return super.func_70005_c_();
        }
        return this.species.getName();
    }

    public boolean func_70601_bi() {
        return true;
    }

    public int func_82145_z() {
        return 1000;
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        return this.textureResource;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity other) {
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.field_70173_aa > 168000;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70128_L) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof IToolScoop) {
            if (!this.field_70170_p.field_72995_K) {
                IButterflyRoot root = this.contained.getGenome().getPrimary().getRoot();
                ILepidopteristTracker tracker = root.getBreedingTracker(this.field_70170_p, player.func_146103_bH());
                ItemStack itemStack = root.getMemberStack(this.contained.copy(), EnumFlutterType.BUTTERFLY);
                tracker.registerCatch(this.contained);
                ItemStackUtil.dropItemStackAsEntity(itemStack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70106_y();
            } else {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean playerKill, int lootLevel) {
        for (ItemStack stack : this.contained.getLootDrop(this, playerKill, lootLevel)) {
            ItemStackUtil.dropItemStackAsEntity(stack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        IIndividual pollen = this.getPollen();
        if (pollen != null) {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(pollen);
            ItemStack pollenStack = root.getMemberStack(pollen, EnumGermlingType.POLLEN);
            ItemStackUtil.dropItemStackAsEntity(pollenStack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            String speciesUid;
            IAllele allele;
            if (this.species == null && (allele = AlleleManager.alleleRegistry.getAllele(speciesUid = (String)this.field_70180_af.func_187225_a(DATAWATCHER_ID_SPECIES))) instanceof IAlleleButterflySpecies) {
                this.species = (IAlleleButterflySpecies)allele;
                this.textureResource = new ResourceLocation(this.species.getEntityTexture());
                this.size = (float)((Integer)this.field_70180_af.func_187225_a(DATAWATCHER_ID_SIZE)).intValue() / 100.0f;
            }
            byte stateOrdinal = (Byte)this.field_70180_af.func_187225_a(DATAWATCHER_ID_STATE);
            if (this.state.ordinal() != stateOrdinal) {
                this.setState(EnumButterflyState.VALUES[stateOrdinal]);
            }
        }
        this.field_70181_x *= (double)0.6f;
        if (this.exhaustion > 100000 && this.func_70681_au().nextInt(20) == 0) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.field_70173_aa > 168000) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
        if (this.cooldownMate > 0) {
            --this.cooldownMate;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getState().doesMovement && this.flightTarget != null) {
            double diffX = this.flightTarget.field_72450_a + 0.5 - this.field_70165_t;
            double diffY = this.flightTarget.field_72448_b + 0.1 - this.field_70163_u;
            double diffZ = this.flightTarget.field_72449_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(diffX) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(diffY) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(diffZ) * 0.5 - this.field_70179_y) * (double)0.1f;
            float horizontal = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            this.field_70177_z += MathHelper.func_76142_g((float)(horizontal - this.field_70177_z));
            this.func_70657_f(this.contained.getGenome().getSpeed());
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_70678_g(float partialTicktime) {
        float flap = this.field_70733_aJ - this.field_70732_aI;
        if (flap < 0.0f) {
            flap += 1.0f;
        }
        return this.field_70732_aI + flap * partialTicktime;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.species == null) {
            return ItemStack.field_190927_a;
        }
        IButterflyRoot root = this.species.getRoot();
        IAllele[] template = root.getTemplate(this.species);
        IButterfly butterfly = root.templateAsIndividual(template);
        return root.getMemberStack(butterfly, EnumFlutterType.BUTTERFLY);
    }

    @Override
    public boolean canMateWith(IEntityButterfly butterfly) {
        if (butterfly.getButterfly().getMate() != null) {
            return false;
        }
        if (this.getButterfly().getMate() != null) {
            return false;
        }
        return !this.getButterfly().isGeneticEqual(butterfly.getButterfly());
    }

    @Override
    public boolean canMate() {
        return this.cooldownMate <= 0;
    }
}

