/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.utils.Log;
import forestry.core.utils.NetworkUtil;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoResponse;
import forestry.mail.network.packets.PacketLetterTextSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerLetter
extends ContainerItemInventory<ItemInventoryLetter>
implements ILetterInfoReceiver {
    private EnumAddressee carrierType = EnumAddressee.PLAYER;
    @Nullable
    private ITradeStationInfo tradeInfo = null;

    public ContainerLetter(EntityPlayer player, ItemInventoryLetter inventory) {
        super(inventory, player.field_71071_by, 17, 145);
        ILetter letter;
        IMailAddress recipient;
        int i;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotFiltered(inventory, 18 + i, 150, 14 + i * 19).setStackLimit(1));
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotFiltered(inventory, 0 + j + i * 9, 17 + j * 18, 98 + i * 18));
            }
        }
        if (!player.field_70170_p.field_72995_K && inventory.getLetter().isProcessed()) {
            inventory.onLetterOpened();
        }
        if ((recipient = (letter = inventory.getLetter()).getRecipient()) != null) {
            this.carrierType = recipient.getType();
        }
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        ILetter letter;
        if (!entityplayer.field_70170_p.field_72995_K && !(letter = ((ItemInventoryLetter)this.inventory).getLetter()).isProcessed()) {
            IMailAddress sender = PostManager.postRegistry.getMailAddress(entityplayer.func_146103_bH());
            letter.setSender(sender);
        }
        ((ItemInventoryLetter)this.inventory).onLetterClosed();
        super.func_75134_a(entityplayer);
    }

    public ILetter getLetter() {
        return ((ItemInventoryLetter)this.inventory).getLetter();
    }

    public void setCarrierType(EnumAddressee type) {
        this.carrierType = type;
    }

    public EnumAddressee getCarrierType() {
        return this.carrierType;
    }

    public void advanceCarrierType() {
        Iterator<IPostalCarrier> it = PostManager.postRegistry.getRegisteredCarriers().values().iterator();
        while (it.hasNext() && !it.next().getType().equals((Object)this.carrierType)) {
        }
        IPostalCarrier postal = it.hasNext() ? it.next() : PostManager.postRegistry.getRegisteredCarriers().values().iterator().next();
        this.setCarrierType(postal.getType());
    }

    public void handleRequestLetterInfo(EntityPlayer player, String recipientName, EnumAddressee type) {
        MinecraftServer server = player.func_184102_h();
        if (server == null) {
            Log.error("Could not get server", new Object[0]);
            return;
        }
        IMailAddress recipient = ContainerLetter.getRecipient(server, recipientName, type);
        this.getLetter().setRecipient(recipient);
        if (recipient == null || recipient.getType() == EnumAddressee.TRADER) {
            this.updateTradeInfo(player.field_70170_p, recipient);
        }
        NetworkUtil.sendToPlayer(new PacketLetterInfoResponse(type, this.tradeInfo, recipient), player);
    }

    @Nullable
    private static IMailAddress getRecipient(MinecraftServer minecraftServer, String recipientName, EnumAddressee type) {
        switch (type) {
            case PLAYER: {
                GameProfile gameProfile = minecraftServer.func_152358_ax().func_152655_a(recipientName);
                if (gameProfile == null) {
                    return null;
                }
                return PostManager.postRegistry.getMailAddress(gameProfile);
            }
            case TRADER: {
                return PostManager.postRegistry.getMailAddress(recipientName);
            }
        }
        return null;
    }

    @Nullable
    public IMailAddress getRecipient() {
        return this.getLetter().getRecipient();
    }

    public String getText() {
        return this.getLetter().getText();
    }

    @SideOnly(value=Side.CLIENT)
    public void setText(String text) {
        this.getLetter().setText(text);
        NetworkUtil.sendToServer(new PacketLetterTextSet(text));
    }

    public void handleSetText(String text) {
        this.getLetter().setText(text);
    }

    private void updateTradeInfo(World world, @Nullable IMailAddress address) {
        if (world.field_72995_K) {
            return;
        }
        if (address == null) {
            this.setTradeInfo(null);
            return;
        }
        ITradeStation station = PostManager.postRegistry.getTradeStation(world, address);
        if (station == null) {
            this.setTradeInfo(null);
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    @Override
    public void handleLetterInfoUpdate(EnumAddressee type, @Nullable IMailAddress address, @Nullable ITradeStationInfo tradeInfo) {
        this.carrierType = type;
        if (type == EnumAddressee.PLAYER) {
            this.getLetter().setRecipient(address);
        } else if (type == EnumAddressee.TRADER) {
            this.setTradeInfo(tradeInfo);
        }
    }

    @Nullable
    public ITradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(@Nullable ITradeStationInfo info) {
        this.tradeInfo = info;
        if (this.tradeInfo == null) {
            this.getLetter().setRecipient(null);
        } else {
            this.getLetter().setRecipient(this.tradeInfo.getAddress());
        }
    }
}

