/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.InventoryUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.greenhouse.gui.ContainerGreenhouseNursery;
import forestry.greenhouse.gui.GuiGreenhouseNursery;
import forestry.greenhouse.inventory.InventoryGreenhouseNursery;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import forestry.lepidopterology.items.ItemButterflyGE;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileGreenhouseNursery
extends TileGreenhouse
implements IGreenhouseComponent.Nursery,
IStreamableGui,
ITickable {
    private static final int WORK_TICK_INTERVAL = 5;
    private static final Random rand = new Random();
    private static final int ENERGY_PER_WORK_CYCLE = 3200;
    private static final int MATURE_TIME_MULTIPLIER = 250;
    private int workCounter;
    private int ticksPerWorkCycle = 4;
    private int energyPerWorkCycle;
    @Nullable
    private IButterfly butterfly;
    private IButterflyCocoon cocoon;
    private int tickCount = rand.nextInt(256);
    private int noPowerTime = 0;
    private final InventoryGreenhouseNursery inventory = new InventoryGreenhouseNursery(this);

    public int getWorkCounter() {
        return this.workCounter;
    }

    public void setTicksPerWorkCycle(int ticksPerWorkCycle) {
        this.ticksPerWorkCycle = ticksPerWorkCycle;
        this.workCounter = 0;
    }

    public int getTicksPerWorkCycle() {
        return this.ticksPerWorkCycle;
    }

    public void setEnergyPerWorkCycle(int energyPerWorkCycle) {
        this.energyPerWorkCycle = EnergyHelper.scaleForDifficulty(energyPerWorkCycle);
    }

    public int getEnergyPerWorkCycle() {
        return this.energyPerWorkCycle;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tickCount;
        if (!this.updateOnInterval(5)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        if (!this.canWork()) {
            return;
        }
        EnergyManager energyManager = ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getEnergyManager();
        if (energyManager == null) {
            return;
        }
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (this.workCounter < ticksPerWorkCycle) {
            int energyPerWorkCycle = this.getEnergyPerWorkCycle();
            boolean consumedEnergy = EnergyHelper.consumeEnergyToDoWork(energyManager, ticksPerWorkCycle, energyPerWorkCycle);
            if (consumedEnergy) {
                errorLogic.setCondition(false, EnumErrorCode.NO_POWER);
                ++this.workCounter;
                this.noPowerTime = 0;
            } else {
                ++this.noPowerTime;
                if (this.noPowerTime > 4) {
                    errorLogic.setCondition(true, EnumErrorCode.NO_POWER);
                }
            }
        }
        if (this.workCounter >= ticksPerWorkCycle && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    protected boolean canWork() {
        Set<IErrorState> queenErrors;
        IErrorLogic errorLogic = this.getErrorLogic();
        Integer inputSlotIndex = this.getInputSlotIndex();
        boolean hasCocoon = inputSlotIndex != null || !this.func_70301_a(0).func_190926_b();
        errorLogic.setCondition(!hasCocoon, EnumErrorCode.NO_RESOURCE_INVENTORY);
        if (this.butterfly == null && hasCocoon) {
            ItemStack stack = this.func_70301_a(0);
            this.butterfly = ButterflyManager.butterflyRoot.getMember(stack);
            if (this.butterfly == null) {
                this.func_70299_a(0, ItemStack.field_190927_a);
                errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_INVENTORY);
                return false;
            }
        }
        if (this.canSpawnButterfly()) {
            queenErrors = this.butterfly.getCanSpawn(this, null);
            for (IErrorState errorState : queenErrors) {
                errorLogic.setCondition(true, errorState);
            }
        } else {
            queenErrors = this.butterfly.getCanGrow(this, null);
            for (IErrorState errorState : queenErrors) {
                errorLogic.setCondition(true, errorState);
            }
        }
        return !errorLogic.hasErrors();
    }

    protected boolean workCycle() {
        this.moveCocoonToWorkSlot();
        if (this.butterfly != null) {
            if (this.canSpawnButterfly()) {
                IGreenhouseControllerInternal controller = ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController();
                if (controller.spawnButterfly(this)) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                    this.setTicksPerWorkCycle(1);
                    this.setEnergyPerWorkCycle(0);
                    this.butterfly = null;
                    this.cocoon = null;
                }
                return false;
            }
            ItemStack stack = this.func_70301_a(0);
            int age = this.getAge();
            IButterflyGenome genome = this.butterfly.getGenome();
            float matureTime = genome.getLifespan() / (genome.getFertility() * 2);
            int caterpillarMatureTime = Math.round(matureTime *= 250.0f);
            if (this.workCounter > 4) {
                ItemButterflyGE.setAge(stack, ++age);
            }
            this.setTicksPerWorkCycle(caterpillarMatureTime);
            this.setEnergyPerWorkCycle(3200);
        }
        return true;
    }

    private boolean canSpawnButterfly() {
        int age = this.getAge();
        return age > 2 && this.butterfly != null;
    }

    private void moveCocoonToWorkSlot() {
        if (!this.func_70301_a(0).func_190926_b()) {
            return;
        }
        Integer slotIndex = this.getInputSlotIndex();
        if (slotIndex == null) {
            return;
        }
        ItemStack inputStack = this.inventory.func_70301_a(slotIndex);
        if (inputStack.func_190926_b()) {
            return;
        }
        ItemStack stack = inputStack.func_77946_l();
        stack.func_190920_e(1);
        inputStack.func_190918_g(1);
        this.func_70299_a(0, stack);
        if (inputStack.func_190926_b()) {
            this.inventory.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
    }

    @Nullable
    private Integer getInputSlotIndex() {
        for (int slotIndex = 0; slotIndex < 6; ++slotIndex) {
            ItemStack inputStack = this.inventory.func_70301_a(7 + slotIndex);
            if (inputStack.func_190926_b()) continue;
            return 7 + slotIndex;
        }
        return null;
    }

    public int getAge() {
        ItemStack cocoon = this.func_70301_a(0);
        if (cocoon.func_190926_b() || !cocoon.func_77942_o()) {
            return -1;
        }
        return cocoon.func_77978_p().func_74762_e("Age");
    }

    public int getProgressScaled(int i) {
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (ticksPerWorkCycle == 0) {
            return 0;
        }
        return this.workCounter * i / ticksPerWorkCycle;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        data.func_150787_b(this.workCounter);
        data.func_150787_b(this.getTicksPerWorkCycle());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.workCounter = data.func_150792_a();
        this.ticksPerWorkCycle = data.func_150792_a();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a("workCounter", this.workCounter);
        data.func_74768_a("ticksPerWorkCycle", this.ticksPerWorkCycle);
        data.func_74768_a("energyPerWorkCycle", this.energyPerWorkCycle);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.workCounter = data.func_74762_e("workCounter");
        this.ticksPerWorkCycle = data.func_74762_e("ticksPerWorkCycle");
        this.energyPerWorkCycle = data.func_74762_e("energyPerWorkCycle");
    }

    @Override
    public void addCocoonLoot(IButterflyCocoon cocoon, NonNullList<ItemStack> cocoonDrops) {
        for (ItemStack drop : cocoonDrops) {
            InventoryUtil.tryAddStack((IInventory)this, drop, 1, 6, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiGreenhouseNursery(player, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerGreenhouseNursery(player.field_71071_by, this);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.greenhouse.nursery.title";
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.butterfly;
    }

    @Override
    public IIndividual getNanny() {
        return null;
    }

    @Override
    public void setCaterpillar(IButterfly caterpillar) {
    }

    @Override
    public boolean canNurse(IButterfly caterpillar) {
        return false;
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.field_174879_c);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_145850_b, this.field_174879_c);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(ClimateUtil.getHumidity(this.field_145850_b, this.field_174879_c));
    }
}

