/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.ITextureManager;
import forestry.core.blocks.BlockForestry;
import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IBlockTypeCustom;
import forestry.core.blocks.IBlockTypeTesr;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.circuits.ISocketable;
import forestry.core.render.MachineParticleCallback;
import forestry.core.render.MachineStateMapper;
import forestry.core.render.ParticleHelper;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase<P extends Enum<P> & IStringSerializable>
extends BlockForestry
implements IItemModelRegister,
ISpriteRegister,
IStateMapperRegister,
IBlockRotatable {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.UP});
    private final boolean hasTESR;
    private final boolean hasCustom;
    public final P blockType;
    private final ParticleHelper.Callback particleCallback;
    protected final BlockStateContainer field_176227_L;

    public BlockBase(P blockType, Material material) {
        super(material);
        this.blockType = blockType;
        ((IBlockType)blockType).getMachineProperties().setBlock(this);
        this.hasTESR = blockType instanceof IBlockTypeTesr;
        this.hasCustom = blockType instanceof IBlockTypeCustom;
        this.field_149786_r = !this.hasTESR && !this.hasCustom ? 255 : 0;
        this.field_176227_L = this.func_180661_e();
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH);
        this.func_180632_j(state);
        this.particleCallback = new MachineParticleCallback<P>(this, blockType);
    }

    public BlockBase(P blockType) {
        this(blockType, Material.field_151573_f);
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.hasTESR && !this.hasCustom;
    }

    public boolean func_149721_r(IBlockState state) {
        return !this.hasTESR && !this.hasCustom;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (this.hasTESR) {
            return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return EnumBlockRenderType.MODEL;
    }

    private IMachineProperties getDefinition() {
        return ((IBlockType)this.blockType).getMachineProperties();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        IMachineProperties definition = this.getDefinition();
        return definition.getBoundingBox(pos, blockState);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        IMachineProperties definition = this.getDefinition();
        return definition.getBoundingBox(pos, state).func_186670_a(pos);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        IMachineProperties definition = this.getDefinition();
        return definition.collisionRayTrace(worldIn, pos, start, end);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.getDefinition().createTileEntity();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileBase tile = TileUtil.getTile((IBlockAccess)worldIn, pos, TileBase.class);
        if (tile != null && TileUtil.isUsableByPlayer(playerIn, tile)) {
            IFluidHandler tileFluidHandler;
            FluidActionResult fluidActionResult;
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (!playerIn.func_70093_af() && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && (fluidActionResult = FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)(tileFluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)), (EntityPlayer)playerIn)).isSuccess()) {
                playerIn.func_184611_a(hand, fluidActionResult.getResult());
                return true;
            }
            if (!worldIn.field_72995_K) {
                tile.openGui(playerIn, heldItem);
            }
            return true;
        }
        return false;
    }

    @Override
    public void rotateAfterPlacement(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = this.getPlacementRotation(player, world, pos, side);
        world.func_175656_a(pos, state.func_177226_a(FACING, (Comparable)facing));
    }

    protected EnumFacing getPlacementRotation(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 1) {
            return EnumFacing.EAST;
        }
        if (l == 2) {
            return EnumFacing.SOUTH;
        }
        if (l == 3) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = TileUtil.getTile((IBlockAccess)world, pos);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            InventoryUtil.dropInventory(inventory, world, pos);
        }
        if (tile instanceof TileForestry) {
            ((TileForestry)tile).onRemoval();
        }
        if (tile instanceof ISocketable) {
            InventoryUtil.dropSockets((ISocketable)tile, tile.func_145831_w(), tile.func_174877_v());
        }
        super.func_180663_b(world, pos, state);
    }

    public void init() {
        ((IBlockType)this.blockType).getMachineProperties().registerTileEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ((IBlockType)this.blockType).getMachineProperties().registerModel(item, manager);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, new MachineStateMapper<P>(this.blockType));
    }

    public boolean func_149686_d(IBlockState state) {
        IMachineProperties definition = this.getDefinition();
        return definition.isFullCube(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public BlockStateContainer func_176194_O() {
        return this.field_176227_L;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return super.func_185471_a(state, mirrorIn);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a(facing));
    }

    public boolean func_149710_n(IBlockState state) {
        return this.hasTESR;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        if (((IBlockType)this.blockType).getMachineProperties() instanceof IMachinePropertiesTesr) {
            return ParticleHelper.addBlockHitEffects(world, target.func_178782_a(), target.field_178784_b, effectRenderer, this.particleCallback);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        if (((IBlockType)this.blockType).getMachineProperties() instanceof IMachinePropertiesTesr) {
            IBlockState blockState = world.func_180495_p(pos);
            return ParticleHelper.addDestroyEffects(world, this, blockState, pos, effectRenderer, this.particleCallback);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        IMachineProperties<?> machineProperties = ((IBlockType)this.blockType).getMachineProperties();
        if (machineProperties instanceof IMachinePropertiesTesr) {
            TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
            String particleTextureLocation = ((IMachinePropertiesTesr)machineProperties).getParticleTextureLocation();
            textureMapBlocks.func_174942_a(new ResourceLocation(particleTextureLocation));
        }
    }
}

