/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimateSource;
import forestry.core.climate.BiomeClimateInfo;
import forestry.core.climate.ClimatePosition;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimateRegion
implements IClimateRegion,
IStreamable {
    protected final World world;
    protected final IGreenhouseControllerInternal controller;
    protected final Set<IClimatePosition> positions;
    protected final Set<IClimateSource> sources;
    protected float temperature;
    protected float humidity;

    public ClimateRegion(IGreenhouseControllerInternal controller, Set<IClimatePosition> positions) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = positions;
        this.sources = new HashSet<IClimateSource>();
        this.calculateAverageClimate();
    }

    public ClimateRegion(IGreenhouseControllerInternal controller) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = new HashSet<IClimatePosition>();
        this.sources = new HashSet<IClimateSource>();
    }

    public ClimateRegion(IGreenhouseControllerInternal controller, NBTTagCompound nbtTag) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = new HashSet<IClimatePosition>();
        this.sources = new HashSet<IClimateSource>();
        this.readFromNBT(nbtTag);
        this.calculateAverageClimate();
    }

    @Override
    public void calculateAverageClimate() {
        this.humidity = 0.0f;
        this.temperature = 0.0f;
        if (!this.positions.isEmpty()) {
            int positions = 0;
            for (IClimatePosition position : this.positions) {
                if (position == null) continue;
                ++positions;
                this.humidity += position.getHumidity();
                this.temperature += position.getTemperature();
            }
            this.temperature /= (float)positions;
            this.humidity /= (float)positions;
        }
    }

    @Override
    public void updateClimate(int ticks) {
        boolean hasChange = false;
        for (IClimateSource source : this.sources) {
            if (source == null || ticks % source.getTicksForChange(this) != 0) continue;
            hasChange |= source.changeClimate(ticks, this);
        }
        if (ticks % this.getTicksPerUpdate() == 0) {
            for (IClimatePosition position : this.positions) {
                BlockPos pos = position.getPos();
                if (!this.world.func_175667_e(pos)) continue;
                hasChange |= this.updateSides(position);
                if (this.controller.isAssembled()) continue;
                IClimateInfo climateInfo = this.getControl(pos);
                if (position.getTemperature() != climateInfo.getTemperature()) {
                    if (position.getTemperature() > climateInfo.getTemperature()) {
                        position.addTemperature(-Math.min(0.01f, position.getTemperature() - climateInfo.getTemperature()));
                        hasChange = true;
                    } else {
                        position.addTemperature(Math.min(0.01f, climateInfo.getTemperature() - position.getTemperature()));
                        hasChange = true;
                    }
                }
                if (position.getHumidity() == climateInfo.getHumidity()) continue;
                if (position.getHumidity() > climateInfo.getHumidity()) {
                    position.addHumidity(-Math.min(0.01f, position.getHumidity() - climateInfo.getHumidity()));
                    hasChange = true;
                    continue;
                }
                position.addHumidity(Math.min(0.01f, climateInfo.getHumidity() - position.getHumidity()));
                hasChange = true;
            }
        }
        if (hasChange) {
            this.calculateAverageClimate();
        }
    }

    protected boolean updateSides(IClimatePosition positon) {
        BlockPos pos = positon.getPos();
        IClimateInfo climateInfo = this.getControl(pos);
        boolean hasChange = false;
        if (climateInfo.getTemperature() != this.temperature || climateInfo.getHumidity() != this.humidity) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                float change;
                IClimatePosition climatedInfoFace = this.getPosition(pos.func_177972_a(facing));
                if (climatedInfoFace == null) continue;
                if (positon.getTemperature() > climatedInfoFace.getTemperature() + 0.01f) {
                    change = Math.min(0.01f, positon.getTemperature() - climatedInfoFace.getTemperature());
                    positon.addTemperature(-change);
                    climatedInfoFace.addTemperature(change);
                    hasChange = true;
                }
                if (!(positon.getHumidity() > climatedInfoFace.getHumidity() + 0.01f)) continue;
                change = Math.min(0.01f, positon.getHumidity() - climatedInfoFace.getHumidity());
                positon.addHumidity(-change);
                climatedInfoFace.addHumidity(change);
                hasChange = true;
            }
        }
        return hasChange;
    }

    protected IClimateInfo getControl(BlockPos pos) {
        if (this.world.func_175667_e(pos) && !this.controller.isAssembled()) {
            return BiomeClimateInfo.getInfo(this.world.func_180494_b(pos));
        }
        return this.controller.getControlClimate();
    }

    @Override
    public Collection<IClimatePosition> getPositions() {
        return this.positions;
    }

    @Override
    public IClimatePosition getPosition(BlockPos pos) {
        for (IClimatePosition position : this.positions) {
            if (!position.getPos().equals((Object)pos)) continue;
            return position;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList positionList = new NBTTagList();
        for (IClimatePosition positon : this.positions) {
            BlockPos pos = positon.getPos();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("X", pos.func_177958_n());
            tag.func_74768_a("Y", pos.func_177956_o());
            tag.func_74768_a("Z", pos.func_177952_p());
            positionList.func_74742_a((NBTBase)positon.writeToNBT(tag));
        }
        nbt.func_74782_a("Positions", (NBTBase)positionList);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList positionList = nbt.func_150295_c("Positions", 10);
        for (int i = 0; i < positionList.func_74745_c(); ++i) {
            int zPos;
            int yPos;
            NBTTagCompound positionTag = positionList.func_150305_b(i);
            int xPos = positionTag.func_74762_e("X");
            BlockPos pos = new BlockPos(xPos, yPos = positionTag.func_74762_e("Y"), zPos = positionTag.func_74762_e("Z"));
            IClimatePosition position = this.getPosition(pos);
            if (position != null) {
                position.readFromNBT(positionTag);
                continue;
            }
            this.positions.add(new ClimatePosition(this, pos, positionTag));
        }
    }

    @Override
    public int getTicksPerUpdate() {
        return 20;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public synchronized void setPosition(BlockPos pos, float temperature, float humidity) {
        IClimatePosition position = this.getPosition(pos);
        if (position != null) {
            position.setHumidity(humidity);
            position.setTemperature(temperature);
        } else {
            this.positions.add(new ClimatePosition(this, pos, temperature, humidity));
        }
    }

    @Override
    public synchronized void addSource(IClimateSource source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
        }
    }

    @Override
    public synchronized void removeSource(IClimateSource source) {
        if (this.sources.contains(source)) {
            this.sources.remove(source);
        }
    }

    @Override
    public Collection<IClimateSource> getSources() {
        return this.sources;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        if (!this.positions.isEmpty()) {
            data.writeInt(this.positions.size());
            data.writeFloat(this.temperature);
            data.writeFloat(this.humidity);
        } else {
            data.writeInt(0);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        int size = data.readInt();
        if (size != 0) {
            this.temperature = data.readFloat();
            this.humidity = data.readFloat();
        }
    }

    @Override
    public float getAverageTemperature() {
        return this.temperature;
    }

    @Override
    public float getAverageHumidity() {
        return this.humidity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClimateRegion)) {
            return false;
        }
        ClimateRegion region = (ClimateRegion)obj;
        return region.controller == this.controller;
    }
}

