/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail.gui;

import java.io.IOException;

import forestry.core.config.Constants;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.mail.network.packets.PacketTraderAddressRequest;
import forestry.mail.tiles.TileTrader;
import net.minecraft.client.gui.GuiTextField;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class GuiTradeName extends GuiForestry<ContainerTradeName> {
	private final TileTrader tile;
	private GuiTextField addressNameField;

	public GuiTradeName(TileTrader tile) {
		super(Constants.TEXTURE_PATH_GUI + "/tradername.png", new ContainerTradeName(tile));
		this.tile = tile;
		this.field_146999_f = 176;
		this.field_147000_g = 90;

		addressNameField = new GuiTextField(0, this.field_146289_q, field_147003_i + 44, field_147009_r + 39, 90, 14);
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		addressNameField = new GuiTextField(0, this.field_146289_q, field_147003_i + 44, field_147009_r + 39, 90, 14);
		addressNameField.func_146180_a(container.getAddress().getName());
		addressNameField.func_146195_b(true);
	}

	@Override
	protected void func_73869_a(char eventCharacter, int eventKey) throws IOException {

		// Set focus or enter text into address
		if (addressNameField.func_146206_l()) {
			if (eventKey == Keyboard.KEY_RETURN) {
				setAddress();
			} else {
				addressNameField.func_146201_a(eventCharacter, eventKey);
			}
			return;
		}

		super.func_73869_a(eventCharacter, eventKey);
	}

	@Override
	protected void func_73864_a(int par1, int par2, int mouseButton) throws IOException {
		super.func_73864_a(par1, par2, mouseButton);
		addressNameField.func_146192_a(par1, par2, mouseButton);
	}

	@Override
	protected void func_146976_a(float var1, int var2, int var3) {
		super.func_146976_a(var1, var2, var3);

		String prompt = Translator.translateToLocal("for.gui.mail.nametrader");
		textLayout.startPage();
		textLayout.newLine();
		textLayout.drawCenteredLine(prompt, 0, ColourProperties.INSTANCE.get("gui.mail.text"));
		textLayout.endPage();
		addressNameField.func_146194_f();
	}

	@Override
	public void func_146281_b() {
		super.func_146281_b();
		setAddress();
	}

	private void setAddress() {
		String address = addressNameField.func_146179_b();
		if (StringUtils.isNotBlank(address)) {
			PacketTraderAddressRequest packet = new PacketTraderAddressRequest(tile, address);
			NetworkUtil.sendToServer(packet);
		}
	}

	@Override
	protected void addLedgers() {
		addErrorLedger(tile);
	}
}
