/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.proxy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import forestry.api.arboriculture.IWoodItemMeshDefinition;
import forestry.api.arboriculture.IWoodStateMapper;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockArbSlab;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.models.ModelDecorativeLeaves;
import forestry.arboriculture.models.ModelLeaves;
import forestry.arboriculture.models.MultipartModel;
import forestry.arboriculture.models.WoodModelLoader;
import forestry.arboriculture.models.WoodTextureManager;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelManager;
import forestry.core.models.SimpleRetexturedModel;
import forestry.core.models.WoodModelEntry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyArboricultureClient
extends ProxyArboriculture {
    private static final Set<WoodModelEntry> woodModelEntrys = new HashSet<WoodModelEntry>();
    private static final Map<IWoodTyped, IWoodStateMapper> stateMappers = Maps.newIdentityHashMap();
    private static final Map<Item, IWoodItemMeshDefinition> shapers = Maps.newHashMap();

    @Override
    public void initializeModels() {
        ModelResourceLocation blockModelLocation = new ModelResourceLocation("forestry:leaves");
        ModelResourceLocation itemModelLocation = new ModelResourceLocation("forestry:leaves", "inventory");
        BlockModelEntry blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelLeaves(), (Block)PluginArboriculture.getBlocks().leaves);
        ModelManager.getInstance().registerCustomBlockModel(blockModelIndex);
        for (BlockDecorativeLeaves leaves : PluginArboriculture.getBlocks().leavesDecorative) {
            String resourceName = "forestry:leaves.decorative." + leaves.getBlockNumber();
            ModelResourceLocation blockModelLocation2 = new ModelResourceLocation(resourceName);
            ModelResourceLocation itemModeLocation = new ModelResourceLocation(resourceName, "inventory");
            BlockModelEntry blockModelIndex2 = new BlockModelEntry(blockModelLocation2, itemModeLocation, new ModelDecorativeLeaves(), leaves);
            ModelManager.getInstance().registerCustomBlockModel(blockModelIndex2);
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)WoodModelLoader.INSTANCE);
        for (BlockArbSlab slab : PluginArboriculture.getBlocks().slabsDouble) {
            this.registerWoodModel(slab, true);
        }
        for (BlockArbSlab slab : PluginArboriculture.getBlocks().slabsDoubleFireproof) {
            this.registerWoodModel(slab, true);
        }
    }

    public static void registerWoodMeshDefinition(Item item, IWoodItemMeshDefinition definition) {
        ModelManager.getInstance().registerItemModel(item, definition);
        shapers.put(item, definition);
    }

    public static void registerWoodStateMapper(Block block, IWoodStateMapper stateMapper) {
        if (block instanceof IWoodTyped) {
            IWoodTyped woodTyped = (IWoodTyped)block;
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)stateMapper);
            stateMappers.put(woodTyped, stateMapper);
        }
    }

    @SubscribeEvent
    public <T extends Block> void onModelBake(ModelBakeEvent event) {
        WoodModelLoader.INSTANCE.isEnabled = true;
        IRegistry registry = event.getModelRegistry();
        for (WoodModelEntry entry : woodModelEntrys) {
            Object woodTyped = entry.woodTyped;
            WoodBlockKind woodKind = ((IWoodTyped)woodTyped).getBlockKind();
            IWoodStateMapper woodMapper = stateMappers.get(woodTyped);
            for (IBlockState blockState : woodTyped.func_176194_O().func_177619_a()) {
                ItemStack itemStack;
                IWoodType woodType;
                if (entry.withVariants) {
                    int meta = woodTyped.func_176201_c(blockState);
                    woodType = ((IWoodTyped)woodTyped).getWoodType(meta);
                    itemStack = new ItemStack(woodTyped, 1, meta);
                } else {
                    woodType = ((IWoodTyped)woodTyped).getWoodType(0);
                    itemStack = new ItemStack(woodTyped);
                }
                IWoodItemMeshDefinition definition = shapers.get(itemStack.func_77973_b());
                ImmutableMap<String, String> textures = WoodTextureManager.getTextures(woodType, woodKind);
                if (definition != null) {
                    this.retextureItemModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, textures, woodType, woodKind, itemStack, definition);
                }
                if (woodMapper == null) continue;
                this.retexturBlockModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, textures, woodType, woodKind, blockState, woodMapper);
            }
        }
    }

    private void retextureItemModel(IRegistry<ModelResourceLocation, IBakedModel> registry, ImmutableMap<String, String> textures, IWoodType woodType, WoodBlockKind woodKind, ItemStack itemStack, IWoodItemMeshDefinition woodDefinition) {
        if (woodKind != WoodBlockKind.DOOR) {
            IModel basicItemModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)woodDefinition.getDefaultModelLocation(itemStack));
            ModelResourceLocation basicItemLocation = woodDefinition.func_178113_a(itemStack);
            registry.func_82595_a((Object)basicItemLocation, (Object)new SimpleRetexturedModel(woodKind.retextureModel(basicItemModel, woodType, textures)));
        }
    }

    private void retexturBlockModel(IRegistry<ModelResourceLocation, IBakedModel> registry, ImmutableMap<String, String> textures, IWoodType woodType, WoodBlockKind woodKind, IBlockState blockState, IWoodStateMapper woodMapper) {
        IModel basicModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)woodMapper.getDefaultModelResourceLocation(blockState));
        if (basicModel instanceof MultipartModel) {
            MultipartModel multipartModel = (MultipartModel)basicModel;
            Multipart multipart = multipartModel.getMultipart();
            multipart.func_188138_a(blockState.func_177230_c().func_176194_O());
        }
        ModelResourceLocation basicLocation = woodMapper.getModelLocation(blockState);
        registry.func_82595_a((Object)basicLocation, (Object)new SimpleRetexturedModel(woodKind.retextureModel(basicModel, woodType, textures)));
    }

    @Override
    public <T extends Block> void registerWoodModel(T woodTyped, boolean withVariants) {
        woodModelEntrys.add(new WoodModelEntry<T>(woodTyped, withVariants));
    }

    @Override
    public int getFoliageColorBasic() {
        return ColorizerFoliage.func_77468_c();
    }

    @Override
    public int getFoliageColorBirch() {
        return ColorizerFoliage.func_77469_b();
    }

    @Override
    public int getFoliageColorPine() {
        return ColorizerFoliage.func_77466_a();
    }
}

