/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import com.google.common.base.Predicate;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.api.core.Tabs;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.CreativeTabForestry;
import forestry.core.blocks.BlockStructure;
import forestry.core.blocks.IBlockRotatable;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.greenhouse.blocks.BlockGreenhouseDoor;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.tiles.TileGreenhouseClimateControl;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseDoor;
import forestry.greenhouse.tiles.TileGreenhouseDryer;
import forestry.greenhouse.tiles.TileGreenhouseFan;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import forestry.greenhouse.tiles.TileGreenhouseHeater;
import forestry.greenhouse.tiles.TileGreenhouseHumidifier;
import forestry.greenhouse.tiles.TileGreenhouseNursery;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import forestry.greenhouse.tiles.TileGreenhouseValve;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockGreenhouse
extends BlockStructure
implements ISpriteRegister,
IColoredBlock,
IBlockRotatable {
    private static final AxisAlignedBB SPRINKLER_BOUNDS = new AxisAlignedBB(0.3125, 0.25, 0.3125, 0.6875, 1.0, 0.6875);
    public static final PropertyEnum<State> STATE = PropertyEnum.func_177709_a((String)"state", State.class);
    public static final PropertyBool BLOCKED = PropertyBool.func_177716_a((String)"blocked");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public static Map<BlockGreenhouseType, BlockGreenhouse> create() {
        EnumMap<BlockGreenhouseType, BlockGreenhouse> blockMap = new EnumMap<BlockGreenhouseType, BlockGreenhouse>(BlockGreenhouseType.class);
        for (final BlockGreenhouseType type : BlockGreenhouseType.VALUES) {
            if (type == BlockGreenhouseType.NURSERY && !ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) continue;
            BlockGreenhouse block = type == BlockGreenhouseType.DOOR ? new BlockGreenhouseDoor() : new BlockGreenhouse(type){

                @Override
                public BlockGreenhouseType getGreenhouseType() {
                    return type;
                }

                public SoundType func_185467_w() {
                    if (this.hasGlass()) {
                        return SoundType.field_185853_f;
                    }
                    return super.func_185467_w();
                }
            };
            blockMap.put(type, block);
        }
        return blockMap;
    }

    public BlockGreenhouse(BlockGreenhouseType type) {
        super(Material.field_151576_e);
        IBlockState defaultState = this.field_176227_L.func_177621_b();
        if (type == BlockGreenhouseType.WINDOW || type == BlockGreenhouseType.WINDOW_UP) {
            defaultState = defaultState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        this.func_180632_j(defaultState);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            this.func_149647_a(Tabs.tabAgriculture);
        } else {
            this.func_149647_a(CreativeTabForestry.tabForestry);
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((IBlockAccess)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return false;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        if (playerIn.func_184614_ca().func_190926_b()) {
            String validationError;
            TileGreenhouseWindow window;
            if (part instanceof TileGreenhouseWindow && (window = (TileGreenhouseWindow)part).getMode() != TileGreenhouseWindow.WindowMode.CONTROL) {
                if (!worldIn.field_72995_K && window.isBlocked() == TileGreenhouseWindow.WindowMode.OPEN) {
                    if (window.getMode() == TileGreenhouseWindow.WindowMode.OPEN) {
                        window.setMode(TileGreenhouseWindow.WindowMode.PLAYER);
                    } else {
                        window.setMode(TileGreenhouseWindow.WindowMode.OPEN);
                    }
                }
                worldIn.func_180498_a(playerIn, this.getPlaySound(!window.isActive()), pos, 0);
                return true;
            }
            if (playerIn.func_184592_cb().func_190926_b() && !controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                long tick = worldIn.func_82737_E();
                if (tick > this.previousMessageTick + 20L) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(validationError));
                    this.previousMessageTick = tick;
                }
                return true;
            }
        }
        if (!controller.isAssembled()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            part.openGui(playerIn);
        }
        return true;
    }

    protected int getPlaySound(boolean open) {
        if (open) {
            return 1007;
        }
        return 1013;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getGreenhouseType() != BlockGreenhouseType.WINDOW && this.getGreenhouseType() != BlockGreenhouseType.WINDOW_UP) {
            return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
        }
        return super.getExtendedState(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return new BlockStateContainer((Block)this, new IProperty[]{STATE, FACING});
        }
        if (this.getGreenhouseType().activatable) {
            return new ExtendedBlockState((Block)this, new IProperty[]{STATE}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
        }
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = TileUtil.getTile(worldIn, pos, TileEntity.class);
        if (tile instanceof IActivatable) {
            state = state.func_177226_a(STATE, (Comparable)((Object)(((IActivatable)tile).isActive() ? State.ON : State.OFF)));
        }
        if (tile instanceof TileGreenhouseWindow) {
            TileGreenhouseWindow tileGreenhouseWindow = (TileGreenhouseWindow)tile;
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a(facing));
    }

    public IBlockState func_176203_a(int meta) {
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta + 2]);
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        if (this.getGreenhouseType() == BlockGreenhouseType.WINDOW || this.getGreenhouseType() == BlockGreenhouseType.WINDOW_UP) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() - 2;
        }
        return 0;
    }

    @Override
    public void rotateAfterPlacement(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177228_b().containsKey((Object)FACING)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()));
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        try {
            TileUtil.actOnTile((IBlockAccess)worldIn, pos, TileGreenhouseWindow.class, TileGreenhouseWindow::onNeighborBlockChange);
        }
        catch (StackOverflowError error) {
            Log.error("Stack Overflow Error in BlockMachine.onNeighborBlockChange()", error);
            throw error;
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        BlockGreenhouseType type = this.getGreenhouseType();
        switch (type) {
            case GEARBOX: {
                return new TileGreenhouseGearbox();
            }
            case DEHUMIDIFIER: {
                return new TileGreenhouseDryer();
            }
            case HUMIDIFIER: {
                return new TileGreenhouseHumidifier();
            }
            case VALVE: {
                return new TileGreenhouseValve();
            }
            case FAN: {
                return new TileGreenhouseFan();
            }
            case HEATER: {
                return new TileGreenhouseHeater();
            }
            case DOOR: {
                return new TileGreenhouseDoor();
            }
            case CONTROL: {
                return new TileGreenhouseControl();
            }
            case CLIMATE_CONTROL: {
                return new TileGreenhouseClimateControl();
            }
            case WINDOW_UP: 
            case WINDOW: {
                return new TileGreenhouseWindow();
            }
            case HATCH_INPUT: 
            case HATCH_OUTPUT: {
                return new TileGreenhouseHatch();
            }
            case NURSERY: {
                return new TileGreenhouseNursery();
            }
        }
        return new TileGreenhousePlain();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (pos == null || worldIn == null) {
            return 0xFFFFFF;
        }
        ICamouflagedTile tile = TileUtil.getTile(worldIn, pos, ICamouflagedTile.class);
        if (tile != null) {
            Block block;
            ItemStack camouflageStack = CamouflageUtil.getCamouflageBlock(worldIn, pos);
            if (tintIndex < 100 && !camouflageStack.func_190926_b() && (block = Block.func_149634_a((Item)camouflageStack.func_77973_b())) != Blocks.field_150350_a) {
                IBlockState camouflageState = block.func_176203_a(camouflageStack.func_77952_i());
                int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(camouflageState, worldIn, pos, tintIndex);
                if (color != -1) {
                    return color;
                }
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.hasGlass()) {
            return BlockRenderLayer.TRANSLUCENT;
        }
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.hasGlass();
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.hasGlass();
    }

    protected boolean hasGlass() {
        BlockGreenhouseType type = this.getGreenhouseType();
        return type == BlockGreenhouseType.GLASS || type == BlockGreenhouseType.WINDOW || type == BlockGreenhouseType.WINDOW_UP;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileUtil.actOnTile((IBlockAccess)world, pos, TileGreenhouseWindow.class, window -> {
            if (!window.func_145831_w().field_72995_K) {
                window.setMode(window.isBlocked());
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (this.getGreenhouseType() == BlockGreenhouseType.GLASS) {
            BlockPos posSide = pos.func_177972_a(side);
            if (blockAccess.func_180495_p(posSide) != iblockstate) {
                return true;
            }
            TileEntity tile = TileUtil.getTile(blockAccess, pos);
            TileEntity tileSide = TileUtil.getTile(blockAccess, posSide);
            if (tile instanceof TileGreenhousePlain && tileSide instanceof TileGreenhousePlain && ((TileGreenhousePlain)tile).getCamouflageType().equals(((TileGreenhousePlain)tileSide).getCamouflageType())) {
                ItemStack camouflage = CamouflageUtil.getCamouflageBlock(blockAccess, pos);
                ItemStack camouflageSide = CamouflageUtil.getCamouflageBlock(blockAccess, posSide);
                if (!camouflage.func_190926_b() && !camouflageSide.func_190926_b()) {
                    return !ItemStackUtil.isIdenticalItem(camouflage, camouflageSide);
                }
            }
            return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
        }
        if (this.getGreenhouseType() == BlockGreenhouseType.DOOR) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        BlockGreenhouseType type = this.getGreenhouseType();
        if (type == BlockGreenhouseType.WINDOW) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.window", "inventory"));
        } else if (type == BlockGreenhouseType.WINDOW_UP) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.window_up", "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse", "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        BlockGreenhouseType.registerSprites();
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return this.getGreenhouseType() == BlockGreenhouseType.CONTROL;
    }

    public abstract BlockGreenhouseType getGreenhouseType();

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Translator.translateToLocal("tile.for.greenhouse.tooltip"));
        tooltip.add(TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString() + Translator.translateToLocal("tile.for.greenhouse.camouflage.tooltip"));
    }

    public static enum State implements IStringSerializable
    {
        ON,
        OFF;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

