/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import forestry.api.food.IBeverageEffect;
import forestry.core.utils.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class BeverageEffect implements IBeverageEffect {
	private final int id;
	private final String unlocalizedDescription;

	protected BeverageEffect(int id, String unlocalizedDescription) {
		this.id = id;
		this.unlocalizedDescription = unlocalizedDescription;

		/*
		if (BeverageManager.effectList[id] != null) {
			throw new RuntimeException("Beverage effect slot " + id + " was already occupied by " + BeverageManager.effectList[id] + " when trying to add " + this);
		} else {
			BeverageManager.effectList[id] = this;
		}
		*/
	}

	@Override
	public int getId() {
		return this.id;
	}

	@Nullable
	protected String getLevel() {
		return null;
	}

	@Override
	public String getDescription() {
		if (getLevel() != null) {
			return Translator.translateToLocal(unlocalizedDescription) + " " + getLevel();
		} else {
			return Translator.translateToLocal(unlocalizedDescription);
		}
	}

	public static List<IBeverageEffect> loadEffects(ItemStack stack) {
		List<IBeverageEffect> effectsList = new ArrayList<>();

		NBTTagCompound nbttagcompound = stack.func_77978_p();
		if (nbttagcompound == null) {
			return effectsList;
		}

		if (nbttagcompound.func_74764_b("E")) {
			int effectLength = nbttagcompound.func_74762_e("L");
			NBTTagList nbttaglist = nbttagcompound.func_150295_c("E", 10);
			IBeverageEffect[] effects = new IBeverageEffect[effectLength];
			for (int i = 0; i < nbttaglist.func_74745_c(); i++) {
				NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
				byte byte0 = nbttagcompound1.func_74771_c("S");
				if (byte0 >= 0 && byte0 < effects.length) {
					//effects[byte0] = BeverageManager.effectList[nbttagcompound1.getInteger("ID")];
				}
			}
			effectsList = Arrays.asList(effects);
		}

		return effectsList;
	}

	public static void saveEffects(ItemStack stack, List<IBeverageEffect> effects) {
		NBTTagCompound nbttagcompound = new NBTTagCompound();

		NBTTagList nbttaglist = new NBTTagList();
		nbttagcompound.func_74768_a("L", effects.size());
		for (int i = 0; i < effects.size(); i++) {
			IBeverageEffect effect = effects.get(i);
			if (effect != null) {
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.func_74774_a("S", (byte) i);
				nbttagcompound1.func_74768_a("ID", effect.getId());
				nbttaglist.func_74742_a(nbttagcompound1);
			}
		}
		nbttagcompound.func_74782_a("E", nbttaglist);

		stack.func_77982_d(nbttagcompound);
	}
}
