/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.entities;

import forestry.apiculture.PluginApiculture;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleBeeRoundTrip extends Particle {
	private final Vec3d origin;
	private final BlockPos destination;

	public ParticleBeeRoundTrip(World world, Vec3d origin, BlockPos destination, int color) {
		super(world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, 0.0D, 0.0D, 0.0D);
		func_187117_a(PluginApiculture.getBeeSprite());
		this.origin = origin;

		this.destination = destination;
		this.field_187129_i = (destination.func_177958_n() + 0.5 - this.field_187126_f) * 0.02 + 0.1 * field_187136_p.nextFloat();
		this.field_187130_j = (destination.func_177956_o() + 0.5 - this.field_187127_g) * 0.015 + 0.1 * field_187136_p.nextFloat();
		this.field_187131_k = (destination.func_177952_p() + 0.5 - this.field_187128_h) * 0.02 + 0.1 * field_187136_p.nextFloat();

		field_70552_h = (color >> 16 & 255) / 255.0F;
		field_70553_i = (color >> 8 & 255) / 255.0F;
		field_70551_j = (color & 255) / 255.0F;

		this.func_187115_a(0.1F, 0.1F);
		this.field_70544_f *= 0.2F;
		this.field_70547_e = (int) (80.0D / (Math.random() * 0.8D + 0.2D));

		this.field_187129_i *= 0.9D;
		this.field_187130_j *= 0.015D;
		this.field_187131_k *= 0.9D;
	}

	/**
	 * Called to update the entity's position/logic.
	 */
	@Override
	public void func_189213_a() {
		this.field_187123_c = this.field_187126_f;
		this.field_187124_d = this.field_187127_g;
		this.field_187125_e = this.field_187128_h;
		this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);

		if (this.field_70546_d == this.field_70547_e / 2) {
			this.field_187129_i = (origin.field_72450_a - this.field_187126_f) * 0.03 + 0.1 * field_187136_p.nextFloat();
			this.field_187130_j = (origin.field_72448_b - this.field_187127_g) * 0.03 + 0.1 * field_187136_p.nextFloat();
			this.field_187131_k = (origin.field_72449_c - this.field_187128_h) * 0.03 + 0.1 * field_187136_p.nextFloat();
		}

		if (this.field_70546_d < this.field_70547_e * 0.25) {
			// venture out
			this.field_187129_i *= 0.92 + 0.2D * field_187136_p.nextFloat();
			this.field_187130_j = (this.field_187130_j + 0.3 * (-0.5 + field_187136_p.nextFloat())) / 2;
			this.field_187131_k *= 0.92 + 0.2D * field_187136_p.nextFloat();
		} else if (this.field_70546_d < this.field_70547_e * 0.5) {
			// get to flower destination
			this.field_187129_i = (destination.func_177958_n() + 0.5 - this.field_187126_f) * 0.03;
			this.field_187130_j = (destination.func_177956_o() + 0.5 - this.field_187127_g) * 0.1;
			this.field_187130_j = (this.field_187130_j + 0.2 * (-0.5 + field_187136_p.nextFloat())) / 2;
			this.field_187131_k = (destination.func_177952_p() + 0.5 - this.field_187128_h) * 0.03;
		} else if (this.field_70546_d < this.field_70547_e * 0.75) {
			// venture back
			this.field_187129_i *= 0.95;
			this.field_187130_j = (origin.field_72448_b - this.field_187127_g) * 0.03;
			this.field_187130_j = (this.field_187130_j + 0.2 * (-0.5 + field_187136_p.nextFloat())) / 2;
			this.field_187131_k *= 0.95;
		} else {
			// get to origin
			this.field_187129_i = (origin.field_72450_a - this.field_187126_f) * 0.03;
			this.field_187130_j = (origin.field_72448_b - this.field_187127_g) * 0.03;
			this.field_187130_j = (this.field_187130_j + 0.2 * (-0.5 + field_187136_p.nextFloat())) / 2;
			this.field_187131_k = (origin.field_72449_c - this.field_187128_h) * 0.03;
		}

		if (this.field_70546_d++ >= this.field_70547_e) {
			this.func_187112_i();
		}
	}

	@Override
	public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		float minU = 0;
		float maxU = 1;
		float minV = 0;
		float maxV = 1;

		if (this.field_187119_C != null) {
			minU = field_187119_C.func_94209_e();
			maxU = field_187119_C.func_94212_f();
			minV = field_187119_C.func_94206_g();
			maxV = field_187119_C.func_94210_h();
		}

		float f10 = 0.1F * field_70544_f;
		float f11 = (float) (field_187123_c + (field_187126_f - field_187123_c) * partialTicks - field_70556_an);
		float f12 = (float) (field_187124_d + (field_187127_g - field_187124_d) * partialTicks - field_70554_ao);
		float f13 = (float) (field_187125_e + (field_187128_h - field_187125_e) * partialTicks - field_70555_ap);

		int i = this.func_189214_a(partialTicks);
		int j = i >> 16 & 65535;
		int k = i & 65535;
		worldRendererIn.func_181662_b(f11 - rotationX * f10 - rotationXY * f10, f12 - rotationZ * f10, f13 - rotationYZ * f10 - rotationXZ * f10).func_187315_a(maxU, maxV).func_181666_a(field_70552_h, field_70553_i, field_70551_j, 1.0F).func_187314_a(j, k).func_181675_d();
		worldRendererIn.func_181662_b(f11 - rotationX * f10 + rotationXY * f10, f12 + rotationZ * f10, f13 - rotationYZ * f10 + rotationXZ * f10).func_187315_a(maxU, minV).func_181666_a(field_70552_h, field_70553_i, field_70551_j, 1.0F).func_187314_a(j, k).func_181675_d();
		worldRendererIn.func_181662_b(f11 + rotationX * f10 + rotationXY * f10, f12 + rotationZ * f10, f13 + rotationYZ * f10 + rotationXZ * f10).func_187315_a(minU, minV).func_181666_a(field_70552_h, field_70553_i, field_70551_j, 1.0F).func_187314_a(j, k).func_181675_d();
		worldRendererIn.func_181662_b(f11 + rotationX * f10 - rotationXY * f10, f12 - rotationZ * f10, f13 + rotationYZ * f10 - rotationXZ * f10).func_187315_a(minU, maxV).func_181666_a(field_70552_h, field_70553_i, field_70551_j, 1.0F).func_187314_a(j, k).func_181675_d();
	}

	// avoid calculating lighting for bees, it is too much processing
	@Override
	public int func_189214_a(float p_189214_1_) {
		return 15728880;
	}

	// avoid calculating collisions
	@Override
	public void func_187110_a(double x, double y, double z) {
		this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
		this.func_187118_j();
	}

	@Override
	public int func_70537_b() {
		return 1;
	}
}
