/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.climate.IClimateSource;
import forestry.api.climate.IClimatiserDefinition;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.climate.ClimateSource;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.greenhouse.GreenhouseClimateSource;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileGreenhouseClimatiser
extends TileGreenhouse
implements IActivatable,
IGreenhouseComponent.Climatiser {
    protected static final int WORK_CYCLES = 1;
    protected static final int ENERGY_PER_OPERATION = 150;
    private final IClimatiserDefinition definition;
    private final ClimateSource source;
    protected final Set<BlockPos> positionsInRange;
    private boolean active;

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition, int ticksForChange) {
        this(definition, new GreenhouseClimateSource(ticksForChange));
    }

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition, ClimateSource source) {
        this.definition = definition;
        this.source = source;
        this.source.setProvider(this);
        this.positionsInRange = new HashSet<BlockPos>();
    }

    protected TileGreenhouseClimatiser(IClimatiserDefinition definition) {
        this(definition, 26);
    }

    @Override
    public void onMachineBroken() {
        this.positionsInRange.clear();
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.positionsInRange.clear();
        float range = this.definition.getRange();
        Iterable allInBox = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177963_a((double)(-range), (double)(-range), (double)(-range)), (BlockPos)this.field_174879_c.func_177963_a((double)range, (double)range, (double)range));
        for (BlockPos pos : allInBox) {
            if (!(pos.func_177951_i((Vec3i)this.field_174879_c) <= (double)range)) continue;
            this.positionsInRange.add(pos);
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public IClimatiserDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public IClimateSource getClimateSource() {
        return this.source;
    }

    public boolean canWork() {
        MultiblockLogicGreenhouse logic = (MultiblockLogicGreenhouse)this.getMultiblockLogic();
        if (!logic.isConnected()) {
            return false;
        }
        EnergyManager energyManager = logic.getController().getEnergyManager();
        return EnergyHelper.consumeEnergyToDoWork(energyManager, 1, 150);
    }

    @Override
    public Set<BlockPos> getPositionsInRange() {
        return this.positionsInRange;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.getCoordinates(), this.getCoordinates());
            } else {
                NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.getCoordinates(), this.field_145850_b);
            }
        }
    }
}

