/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean areFluidStacksEqual(@Nullable FluidStack fluidStack1, @Nullable FluidStack fluidStack2) {
        if (fluidStack1 == null) {
            return fluidStack2 == null;
        }
        return fluidStack1.isFluidStackIdentical(fluidStack2);
    }

    public static boolean canAcceptFluid(World world, BlockPos pos, EnumFacing facing, FluidStack fluid) {
        IFluidHandler capability = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)facing);
        if (capability != null) {
            if (capability.getTankProperties() == null) {
                throw new NullPointerException("The fluid handler " + capability.toString() + " returns null in the method getTankProperties, this is not allowed, please report that to the author of the mod from that the handler is.");
            }
            for (IFluidTankProperties tankProperties : capability.getTankProperties()) {
                if (!tankProperties.canFillFluidType(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, FluidHelper.getEmptyContainer(inv.func_70301_a(inputSlot)), doFill);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, ItemStack emptyStack, boolean doFill) {
        boolean moveToOutput;
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = input.func_77946_l();
        filled.func_190920_e(1);
        if (emptyStack.func_190926_b()) {
            emptyStack = filled;
        }
        IFluidHandlerItem fluidFilledHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        IFluidHandlerItem fluidEmptyHandler = FluidUtil.getFluidHandler((ItemStack)emptyStack);
        if (fluidFilledHandler == null || fluidEmptyHandler == null) {
            return FillStatus.INVALID_INPUT;
        }
        int containerEmptyCapacity = fluidEmptyHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), false);
        int containerCapacity = fluidFilledHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), false);
        if (containerCapacity <= 0 && containerEmptyCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        FluidStack canDrain = fluidHandler.drain(new FluidStack(fluidToFill, containerCapacity), false);
        if (canDrain == null || canDrain.amount == 0) {
            return FillStatus.NO_FLUID;
        }
        if (fluidFilledHandler.fill(canDrain, true) <= 0) {
            return FillStatus.NO_FLUID;
        }
        FluidStack fluidInContainer = fluidFilledHandler.drain(Integer.MAX_VALUE, false);
        if (fluidInContainer == null) {
            return FillStatus.INVALID_INPUT;
        }
        filled = fluidFilledHandler.getContainer();
        boolean bl = moveToOutput = fluidInContainer.amount >= containerCapacity;
        if (moveToOutput ? !output.func_190926_b() && (output.func_190916_E() >= output.func_77976_d() || !InventoryUtil.isItemEqual(filled, output)) : input.func_190916_E() > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(canDrain, true);
            if (moveToOutput) {
                if (output.func_190926_b()) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    output.func_190917_f(1);
                }
                inv.func_70298_a(inputSlot, 1);
            } else {
                inv.func_70299_a(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot) {
        FluidActionResult fluidActionResult;
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return false;
        }
        FluidActionResult fluidActionSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (!fluidActionSimulated.isSuccess()) {
            return false;
        }
        ItemStack drainedItemSimulated = fluidActionSimulated.getResult();
        if ((input.func_190916_E() == 1 || drainedItemSimulated.func_190926_b()) && (fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)).isSuccess()) {
            ItemStack drainedItem = fluidActionResult.getResult();
            if (!drainedItem.func_190926_b()) {
                inv.func_70299_a(inputSlot, drainedItem);
            } else {
                inv.func_70298_a(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static FillStatus drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, boolean doDrain) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack outputStack = inv.func_70301_a(outputSlot);
        FluidActionResult drainedResultSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (!drainedResultSimulated.isSuccess()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack drainedItemSimulated = drainedResultSimulated.getResult();
        if (outputStack.func_190926_b() || drainedItemSimulated.func_190926_b() || ItemStackUtil.isIdenticalItem(outputStack, drainedItemSimulated) && outputStack.func_190916_E() + drainedItemSimulated.func_190916_E() < outputStack.func_77976_d()) {
            FluidActionResult drainedResult;
            if (doDrain && (drainedResult = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)).isSuccess()) {
                ItemStack drainedItem = drainedResult.getResult();
                if (!drainedItem.func_190926_b()) {
                    ItemStack newStack = drainedItem.func_77946_l();
                    if (!outputStack.func_190926_b()) {
                        newStack.func_190917_f(outputStack.func_190916_E());
                    }
                    if (FluidHelper.isFillableContainerAndEmpty(newStack)) {
                        inv.func_70299_a(outputSlot, newStack);
                        inv.func_70298_a(inputSlot, 1);
                    }
                } else {
                    inv.func_70298_a(inputSlot, 1);
                }
                return FillStatus.SUCCESS;
            }
            return FillStatus.SUCCESS;
        }
        return FillStatus.NO_SPACE;
    }

    public static boolean isFillableContainerAndEmpty(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount <= 0) continue;
            return false;
        }
        return false;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return ItemStack.field_190927_a;
        }
        if (fluidHandler.drain(Integer.MAX_VALUE, true) != null) {
            return empty;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isFillableContainerWithRoom(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount >= properties.getCapacity()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents == null || contents.amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount >= properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE,
        NO_SPACE_FLUID;

    }
}

