/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateRegion;
import forestry.api.core.ForestryAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClimateEventHandler {
    private final Map<World, Integer> serverTicks = new HashMap<World, Integer>();

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unloadWorldEvent) {
        ForestryAPI.climateManager.onWorldUnload(unloadWorldEvent.getWorld());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        MinecraftServer server;
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && (server = world.func_73046_m()) != null) {
            server.func_152344_a(() -> {
                if (!this.serverTicks.containsKey(world)) {
                    this.serverTicks.put(world, 1);
                }
                int ticks = this.serverTicks.get(world);
                Map<World, List<IClimateRegion>> regions = ForestryAPI.climateManager.getRegions();
                if (regions.containsKey(world)) {
                    for (IClimateRegion region : regions.get(world)) {
                        region.updateClimate(ticks);
                    }
                }
                this.serverTicks.put(world, ticks + 1);
            });
        }
    }
}

