/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.arboriculture.models.MultipartModel;
import forestry.arboriculture.models.SimpleModel;
import forestry.core.utils.ModelUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum WoodModelLoader implements ICustomModelLoader
{
    INSTANCE;

    public static final List<String> validFiles;
    public boolean isEnabled = false;

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (!(this.isEnabled && modelLocation instanceof ModelResourceLocation && modelLocation.func_110624_b().equals("forestry") && modelLocation.func_110623_a().contains("arboriculture"))) {
            return false;
        }
        String path = modelLocation.func_110623_a();
        for (String validFile : validFiles) {
            if (!path.endsWith(validFile)) continue;
            return true;
        }
        return false;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        ModelResourceLocation variant = (ModelResourceLocation)modelLocation;
        ModelBlockDefinition definition = ModelUtil.getModelBlockDefinition((ResourceLocation)variant);
        try {
            VariantList variants = definition.func_188004_c(variant.func_177518_c());
            return new SimpleModel((ResourceLocation)variant, variants);
        }
        catch (ModelBlockDefinition.MissingVariantException e) {
            if (definition.func_188002_b()) {
                return new MultipartModel(new ResourceLocation(variant.func_110624_b(), variant.func_110623_a()), definition.func_188001_c());
            }
            throw e;
        }
    }

    static {
        validFiles = new ArrayList<String>();
        validFiles.add("door");
        validFiles.add("double_slab");
        validFiles.add("fence");
        validFiles.add("fence_gate");
        validFiles.add("log");
        validFiles.add("planks");
        validFiles.add("slab");
        validFiles.add("stairs");
    }
}

