/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetCamouflageSlot;
import forestry.core.gui.widgets.WidgetManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class WidgetCamouflageTab
extends Widget {
    private final WidgetCamouflageSlot greenhouseSlot;
    @Nullable
    private final WidgetCamouflageSlot handlerSlot;
    private final ItemStack typeStack;

    public WidgetCamouflageTab(WidgetManager manager, int xPos, int yPos, IGreenhouseController controller, ICamouflageHandler camouflageHandler, String type) {
        super(manager, xPos, yPos);
        this.width = 48;
        this.height = 25;
        this.greenhouseSlot = new WidgetCamouflageSlot(manager, xPos + 26, yPos + 6, controller, type);
        if (camouflageHandler.canHandleType(type)) {
            this.handlerSlot = new WidgetCamouflageSlot(manager, xPos + 46, yPos + 6, camouflageHandler, type);
            this.width += 20;
        } else {
            this.handlerSlot = null;
        }
        switch (type) {
            case "block": {
                this.typeStack = new ItemStack(Blocks.field_150336_V);
                break;
            }
            case "glass": {
                this.typeStack = new ItemStack(Blocks.field_150359_w);
                break;
            }
            case "door": {
                this.typeStack = new ItemStack(Items.field_179570_aq);
                break;
            }
            default: {
                this.typeStack = ItemStack.field_190927_a;
            }
        }
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(this.manager.gui.textureFile);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 192, 0, 48, 25);
        if (this.handlerSlot != null) {
            this.manager.gui.func_73729_b(startX + this.xPos + 44, startY + this.yPos, 192, 25, 24, 25);
        }
        if (!this.typeStack.func_190926_b()) {
            textureManager.func_110577_a(TextureMap.field_110575_b);
            RenderItem renderItem = minecraft.func_175599_af();
            renderItem.func_175042_a(this.typeStack, startX + this.xPos + 6, startY + this.yPos + 6);
        }
        this.greenhouseSlot.draw(startX, startY);
        if (this.handlerSlot != null) {
            this.handlerSlot.draw(startX, startY);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.greenhouseSlot.isMouseOver(mouseX -= this.manager.gui.getGuiLeft(), mouseY -= this.manager.gui.getGuiTop())) {
            this.greenhouseSlot.handleMouseClick(mouseX, mouseY, mouseButton);
        } else if (this.handlerSlot != null && this.handlerSlot.isMouseOver(mouseX, mouseY)) {
            this.handlerSlot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        return this.isMouseOver(mouseX - this.manager.gui.getGuiLeft(), mouseY - this.manager.gui.getGuiTop());
    }

    @Nullable
    public WidgetCamouflageSlot getHandlerSlot() {
        return this.handlerSlot;
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.greenhouseSlot.isMouseOver(mouseX, mouseY)) {
            return this.greenhouseSlot.getToolTip(mouseX, mouseY);
        }
        if (this.handlerSlot != null && this.handlerSlot.isMouseOver(mouseX, mouseY)) {
            return this.handlerSlot.getToolTip(mouseX, mouseY);
        }
        return null;
    }
}

