package forestry.lepidopterology;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.utils.Log;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ButterflyUtils {
	
	private static boolean attemptButterflySpawn(World world, IButterfly butterfly, BlockPos pos) {
		EntityLiving entityLiving = ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), pos.func_177958_n(), pos.func_177956_o() + 0.1f, pos.func_177952_p());
		Log.trace("Spawned a butterfly '%s' at %s/%s/%s.", butterfly.getDisplayName(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
		return entityLiving != null;
	}
	
	public static boolean spawnButterfly(IButterfly butterfly, World world, BlockPos pos){
		if (world.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
			return false;
		}

		if (!butterfly.canSpawn(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
			return false;
		}

		if (world.func_175623_d(pos)) {
			return attemptButterflySpawn(world, butterfly, pos);
		}
		return false;
	}

	
}
