/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock;

import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimateSourceProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ICamouflagedTile;
import forestry.api.greenhouse.GreenhouseEvents;
import forestry.api.greenhouse.IInternalBlock;
import forestry.api.greenhouse.IInternalBlockFace;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.climate.ClimateInfo;
import forestry.core.climate.ClimatePosition;
import forestry.core.climate.ClimateRegion;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectServer;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;
import forestry.greenhouse.inventory.InventoryGreenhouse;
import forestry.greenhouse.multiblock.GreenhouseMultiblockSizeLimits;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.InternalBlock;
import forestry.greenhouse.tiles.TileGreenhouseHumidifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GreenhouseController
extends RectangularMultiblockControllerBase
implements IGreenhouseControllerInternal,
ILiquidTankTile {
    private final Set<IInternalBlock> internalBlocks = new HashSet<IInternalBlock>();
    private final Set<IGreenhouseComponent.Listener> listenerComponents = new HashSet<IGreenhouseComponent.Listener>();
    private final Set<IGreenhouseComponent.Active> activeComponents = new HashSet<IGreenhouseComponent.Active>();
    private final Set<IGreenhouseComponent.Climatiser> climatiserComponents = new HashSet<IGreenhouseComponent.Climatiser>();
    @Nullable
    protected IGreenhouseComponent.ClimateControl climateControl;
    @Nullable
    protected IGreenhouseComponent.ButterflyHatch butterflyHatch;
    private final TankManager tankManager;
    private final EnergyManager energyManager;
    private final InventoryGreenhouse inventory;
    private final boolean needRenderUpdate = false;
    private ItemStack camouflagePlainBlock;
    private ItemStack camouflageGlassBlock;
    private ItemStack camouflageDoorBlock;
    private ClimateRegion region;

    public GreenhouseController(World world) {
        super(world, GreenhouseMultiblockSizeLimits.instance);
        FilteredTank resourceTank = new FilteredTank(10000).setFilters(FluidRegistry.WATER);
        this.tankManager = new TankManager(this, resourceTank);
        this.energyManager = new EnergyManager(200, 100000);
        this.inventory = new InventoryGreenhouse(this);
        this.camouflagePlainBlock = this.getDefaultCamouflageBlock("block");
        this.camouflageGlassBlock = this.getDefaultCamouflageBlock("glass");
        this.camouflageDoorBlock = this.getDefaultCamouflageBlock("door");
        this.region = new ClimateRegion(this);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.region.getAverageTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.region.getAverageHumidity();
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.greenhouse.type";
    }

    @Override
    public BlockPos getCoordinates() {
        return this.getReferenceCoord();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.energyManager.writeToNBT(data);
        this.inventory.writeToNBT(data);
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "block");
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "glass");
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "door");
        data.func_74782_a("Region", (NBTBase)this.region.writeToNBT(new NBTTagCompound()));
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.energyManager.readFromNBT(data);
        this.inventory.readFromNBT(data);
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "block");
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "glass");
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "door");
        if (data.func_74764_b("Region")) {
            NBTTagCompound nbtTag = data.func_74775_l("Region");
            if (this.region != null) {
                this.region.readFromNBT(nbtTag);
            }
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.tankManager.writeData(data);
        this.energyManager.writeData(data);
        this.inventory.writeData(data);
        CamouflageUtil.writeCamouflageBlockToData(data, this, "block");
        CamouflageUtil.writeCamouflageBlockToData(data, this, "glass");
        CamouflageUtil.writeCamouflageBlockToData(data, this, "door");
        this.region.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.tankManager.readData(data);
        this.energyManager.readData(data);
        this.inventory.readData(data);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        this.region.readData(data);
    }

    @Override
    public boolean canHandleType(String type) {
        return type.equals("block") || type.equals("glass") || type.equals("door");
    }

    @Override
    public boolean setCamouflageBlock(String type, ItemStack camouflageBlock, boolean sendClientUpdate) {
        ItemStack oldCamouflageBlock;
        switch (type) {
            case "block": {
                oldCamouflageBlock = this.camouflagePlainBlock;
                break;
            }
            case "glass": {
                oldCamouflageBlock = this.camouflageGlassBlock;
                break;
            }
            case "door": {
                oldCamouflageBlock = this.camouflageDoorBlock;
                break;
            }
            default: {
                return false;
            }
        }
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, oldCamouflageBlock)) {
            switch (type) {
                case "block": {
                    this.camouflagePlainBlock = camouflageBlock;
                    break;
                }
                case "glass": {
                    this.camouflageGlassBlock = camouflageBlock;
                    break;
                }
                case "door": {
                    this.camouflageDoorBlock = camouflageBlock;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (sendClientUpdate && this.world.field_72995_K) {
                for (IMultiblockComponent comp : this.connectedParts) {
                    ICamouflagedTile camBlock;
                    if (!(comp instanceof ICamouflagedTile) || !(camBlock = (ICamouflagedTile)((Object)comp)).getCamouflageType().equals(type)) continue;
                    this.world.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
                }
                NetworkUtil.sendToServer(new PacketCamouflageSelectServer(this, type, CamouflageSelectionType.MULTIBLOCK));
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getCamouflageBlock(String type) {
        switch (type) {
            case "block": {
                return this.camouflagePlainBlock;
            }
            case "glass": {
                return this.camouflageGlassBlock;
            }
            case "door": {
                return this.camouflageDoorBlock;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(String type) {
        switch (type) {
            case "block": {
                return new ItemStack(Blocks.field_150336_V);
            }
            case "glass": {
                return new ItemStack((Block)Blocks.field_150399_cn, 1, 13);
            }
            case "door": {
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    private void addNewPositions(Collection<IClimatePosition> newPositions) {
        for (IClimatePosition position : newPositions) {
            BlockPos pos = position.getPos();
            IClimatePosition oldPosition = this.region.getPosition(pos);
            float temperature = position.getTemperature();
            float humidity = position.getHumidity();
            if (oldPosition != null) {
                temperature = oldPosition.getTemperature();
                humidity = oldPosition.getHumidity();
            }
            this.region.setPosition(pos, temperature, humidity);
        }
        this.region.calculateAverageClimate();
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        HashSet<IClimatePosition> internalPositions = new HashSet<IClimatePosition>();
        for (IInternalBlock iInternalBlock : this.internalBlocks) {
            if (iInternalBlock == null) continue;
            internalPositions.add(new ClimatePosition(this.region, iInternalBlock.getPos()));
        }
        this.addNewPositions(internalPositions);
        ForestryAPI.climateManager.addRegion(this.region);
        for (IClimateSourceProvider iClimateSourceProvider : this.climatiserComponents) {
            this.region.addSource(iClimateSourceProvider.getClimateSource());
        }
        for (IMultiblockComponent iMultiblockComponent : this.connectedParts) {
            if (!(iMultiblockComponent instanceof ICamouflagedTile)) continue;
            this.world.func_175704_b(iMultiblockComponent.getCoordinates(), iMultiblockComponent.getCoordinates());
        }
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.internalBlocks.clear();
        ForestryAPI.climateManager.removeRegion(this.region);
        for (IClimateSourceProvider iClimateSourceProvider : this.climatiserComponents) {
            this.region.removeSource(iClimateSourceProvider.getClimateSource());
        }
        for (IMultiblockComponent iMultiblockComponent : this.connectedParts) {
            if (!(iMultiblockComponent instanceof ICamouflagedTile)) continue;
            this.world.func_175704_b(iMultiblockComponent.getCoordinates(), iMultiblockComponent.getCoordinates());
        }
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.add((IGreenhouseComponent.Listener)newPart);
        } else if (newPart instanceof IGreenhouseComponent.Climatiser) {
            this.climatiserComponents.add((IGreenhouseComponent.Climatiser)newPart);
        } else if (newPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.add((IGreenhouseComponent.Active)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.remove(oldPart);
        } else if (oldPart instanceof IGreenhouseComponent.Climatiser) {
            this.climatiserComponents.remove(oldPart);
            ForestryAPI.climateManager.removeSource((IClimateSourceProvider)((Object)oldPart));
        } else if (oldPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.remove(oldPart);
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
        IGreenhouseControllerInternal internal = (IGreenhouseControllerInternal)assimilated;
        this.addNewPositions(internal.getRegion().getPositions());
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
        if (this.isAssembled()) {
            ForestryAPI.climateManager.removeRegion(this.region);
        }
    }

    @Override
    protected boolean updateServer(int tickCount) {
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
        for (IGreenhouseComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.getSizeLimits().getMinimumXSize();
        int minY = this.getSizeLimits().getMinimumYSize();
        int minZ = this.getSizeLimits().getMinimumZSize();
        if (this.connectedParts.size() < this.getSizeLimits().getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small", minX, minY, minZ));
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getSizeLimits().getMaximumXSize();
        int maxY = this.getSizeLimits().getMaximumYSize();
        int maxZ = this.getSizeLimits().getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.x", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.y", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.z", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.x", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.y", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.z", minZ));
        }
        boolean isNextRoof = false;
        Class<?> myClass = this.getClass();
        for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o() && !isNextRoof; ++y) {
            for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    int delta;
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = TileUtil.getTile((IBlockAccess)this.world, pos);
                    IMultiblockComponent part = te instanceof IMultiblockComponent ? (IMultiblockComponent)te : null;
                    int extremes = 0;
                    int sides = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.func_177956_o();
                        if (part != null) {
                            if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())), part.getCoordinates());
                            }
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                        } else {
                            this.isBlockGoodForExteriorLevel(exteriorLevel, this.world, pos);
                        }
                    } else if (part != null) {
                        IBlockState state = this.world.func_180495_p(part.getCoordinates());
                        if (myClass.equals(part.getMultiblockLogic().getController().getClass())) throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())), part.getCoordinates());
                        this.isGoodForInterior(part);
                    } else {
                        this.isBlockGoodForInterior(this.world, pos);
                    }
                    BlockPos posUp = pos.func_177981_b(2);
                    TileEntity tileUp = TileUtil.getTile((IBlockAccess)this.world, posUp);
                    if (sides < 1 || tileUp instanceof IGreenhouseComponent || (delta = y - minimumCoord.func_177956_o()) + 2 < minY) continue;
                    isNextRoof = true;
                }
            }
        }
        this.internalBlocks.clear();
        if (isNextRoof) {
            this.checkInternalBlocks();
        }
        if (this.internalBlocks.isEmpty()) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.space.closed"));
        }
        HashSet<IGreenhouseComponent.ButterflyHatch> hatches = new HashSet<IGreenhouseComponent.ButterflyHatch>();
        HashSet<IGreenhouseComponent.ClimateControl> controls = new HashSet<IGreenhouseComponent.ClimateControl>();
        for (IMultiblockComponent comp : this.connectedParts) {
            if (comp instanceof IGreenhouseComponent.ButterflyHatch) {
                hatches.add((IGreenhouseComponent.ButterflyHatch)comp);
                continue;
            }
            if (!(comp instanceof IGreenhouseComponent.ClimateControl)) continue;
            controls.add((IGreenhouseComponent.ClimateControl)comp);
        }
        if (hatches.size() > 1) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.butterflyhatch.toomany"));
        }
        if (controls.size() > 1) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.climatecontrol.toomany"));
        }
        if (hatches.iterator().hasNext()) {
            this.butterflyHatch = (IGreenhouseComponent.ButterflyHatch)hatches.iterator().next();
        }
        if (!controls.iterator().hasNext()) return;
        this.climateControl = (IGreenhouseComponent.ClimateControl)controls.iterator().next();
    }

    @Override
    protected void updateClient(int tickCount) {
    }

    private void checkInternalBlocks() throws MultiblockValidationException {
        Stack<IInternalBlock> blocksToCheck = new Stack<IInternalBlock>();
        IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(this.getMinimumCoord().func_177982_a(1, 1, 1)));
        blocksToCheck.add(internalBlock);
        while (!blocksToCheck.isEmpty()) {
            IInternalBlock blockToCheck = (IInternalBlock)blocksToCheck.pop();
            List<IInternalBlock> newBlocksToCheck = this.checkInternalBlock(blockToCheck);
            blocksToCheck.addAll(newBlocksToCheck);
        }
    }

    private List<IInternalBlock> checkInternalBlock(IInternalBlock blockToCheck) throws MultiblockValidationException {
        ArrayList<IInternalBlock> newBlocksToCheck = new ArrayList<IInternalBlock>();
        this.internalBlocks.add(blockToCheck);
        BlockPos posRoot = blockToCheck.getPos();
        this.isBlockGoodForInterior(this.world, posRoot);
        for (IInternalBlockFace faceToCheck : blockToCheck.getFaces()) {
            GreenhouseEvents.CheckInternalBlockFaceEvent checkEvent = new GreenhouseEvents.CheckInternalBlockFaceEvent(this, blockToCheck, faceToCheck);
            MinecraftForge.EVENT_BUS.post((Event)checkEvent);
            if (faceToCheck.isTested()) continue;
            EnumFacing face = faceToCheck.getFace();
            BlockPos posFacing = posRoot.func_177972_a(face);
            BlockPos minPos = this.getMinimumCoord();
            BlockPos maxPos = this.getMaximumCoord();
            if (minPos.func_177958_n() > posFacing.func_177958_n() || minPos.func_177956_o() > posFacing.func_177956_o() || minPos.func_177952_p() > posFacing.func_177952_p() || maxPos.func_177958_n() < posFacing.func_177958_n() || maxPos.func_177956_o() < posFacing.func_177956_o() || maxPos.func_177952_p() < posFacing.func_177952_p()) {
                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.space.closed", new Object[0]), posRoot);
            }
            TileEntity tileFace = TileUtil.getTile((IBlockAccess)this.world, posFacing);
            if (tileFace instanceof IGreenhouseComponent) {
                if (((IGreenhouseComponent)tileFace).getMultiblockLogic().getController() != this) {
                    throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.not.connected.part", new Object[0]), posRoot);
                }
                if (tileFace instanceof TileGreenhouseHumidifier) continue;
                faceToCheck.setTested(true);
                continue;
            }
            IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(posFacing, face.func_176734_d(), blockToCheck));
            if (this.internalBlocks.contains(internalBlock)) {
                faceToCheck.setTested(true);
                continue;
            }
            newBlocksToCheck.add(internalBlock);
        }
        return newBlocksToCheck;
    }

    private IInternalBlock createInternalBlock(IInternalBlock internalBlock) {
        GreenhouseEvents.CreateInternalBlockEvent createEvent = new GreenhouseEvents.CreateInternalBlockEvent(this, internalBlock);
        MinecraftForge.EVENT_BUS.post((Event)createEvent);
        return createEvent.internalBlock;
    }

    @Override
    public Set<IInternalBlock> getInternalBlocks() {
        return this.internalBlocks;
    }

    @Override
    public IClimateInfo getControlClimate() {
        if (this.climateControl == null) {
            return ClimateInfo.MAX;
        }
        return this.climateControl.getControlClimate();
    }

    @Override
    public void setControlClimate(IClimateInfo climateControl) {
        if (this.climateControl != null) {
            this.climateControl.setControlClimate(climateControl);
        }
    }

    @Override
    @Nullable
    public IGreenhouseComponent.ButterflyHatch getButterflyHatch() {
        return this.butterflyHatch;
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
    }

    @Override
    protected void isBlockGoodForInterior(World world, BlockPos pos) throws MultiblockValidationException {
    }

    @Override
    public IClimateRegion getRegion() {
        return this.region;
    }

    @Override
    public Set<IGreenhouseComponent.Listener> getListenerComponents() {
        return this.listenerComponents;
    }

    @Override
    public boolean canWork() {
        boolean canWork = true;
        for (IGreenhouseComponent.Listener listenerComponent : this.listenerComponents) {
            canWork = listenerComponent.getGreenhouseListener().canWork(this, canWork);
        }
        return canWork;
    }
}

