/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.blocks;

import java.util.Random;

import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.models.GreenhouseDoorStateMapper;
import forestry.greenhouse.tiles.TileGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGreenhouseDoor extends BlockGreenhouse implements IStateMapperRegister {

	//The door properties
	private static final PropertyDirection FACING = BlockDoor.field_176520_a;
	private static final PropertyBool OPEN = BlockDoor.field_176519_b;
	private static final PropertyEnum<BlockDoor.EnumHingePosition> HINGE = BlockDoor.field_176521_M;
	private static final PropertyBool POWERED = BlockDoor.field_176522_N;
	private static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = BlockDoor.field_176523_O;
	public static final PropertyBool CAMOUFLAGED = PropertyBool.func_177716_a("camouflaged");

	protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 0.1875D);
	protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.8125D, 1.0D, 1.0D, 1.0D);
	protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D);
	protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.0D, 0.1875D, 1.0D, 1.0D);

	public BlockGreenhouseDoor() {
		super(BlockGreenhouseType.DOOR);
		func_149672_a(SoundType.field_185853_f);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, EnumFacing.NORTH).func_177226_a(OPEN, false).func_177226_a(HINGE, BlockDoor.EnumHingePosition.LEFT).func_177226_a(POWERED, false).func_177226_a(HALF, BlockDoor.EnumDoorHalf.LOWER).func_177226_a(CAMOUFLAGED, false));
	}

	@Override
	public String func_149732_F() {
		return Translator.translateToLocal((this.func_149739_a() + ".name").replaceAll("tile", "item"));
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
		return isOpen(combineMetadata(worldIn, pos));
	}

	@Override
	public boolean func_149686_d(IBlockState state) {
		return false;
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
		state = state.func_185899_b(source, pos);
		EnumFacing enumfacing = state.func_177229_b(FACING);
		boolean flag = !state.func_177229_b(OPEN);
		boolean flag1 = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT;

		switch (enumfacing) {
			case EAST:
			default:
				return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
			case SOUTH:
				return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
			case WEST:
				return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
			case NORTH:
				return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
		}
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		TileGreenhouse door = TileUtil.getTile(worldIn, pos, TileGreenhouse.class);
		if (door == null) {
			return false;
		}

		if (playerIn.func_70093_af() && playerIn.func_184586_b(hand).func_190926_b()) {
			if (!worldIn.field_72995_K) {
				door.openGui(playerIn);
			}
			return true;
		}

		BlockPos blockpos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
		IBlockState iblockstate = pos.equals(blockpos) ? state : worldIn.func_180495_p(blockpos);

		if (iblockstate.func_177230_c() != this) {
			return false;
		} else {
			state = iblockstate.func_177231_a(OPEN);
			worldIn.func_180501_a(blockpos, state, 2);
			worldIn.func_175704_b(blockpos, pos);
			worldIn.func_180498_a(playerIn, state.func_177229_b(OPEN) ? 1005 : 1011, pos, 0);
			return true;
		}
	}

	@Override
	@Deprecated
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
		if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
			BlockPos blockpos = pos.func_177977_b();
			IBlockState iblockstate = worldIn.func_180495_p(blockpos);

			if (iblockstate.func_177230_c() != this) {
				worldIn.func_175698_g(pos);
			} else if (blockIn != this) {
				iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
			}
		} else {
			boolean flag1 = false;
			BlockPos blockpos1 = pos.func_177984_a();
			IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);

			if (iblockstate1.func_177230_c() != this) {
				worldIn.func_175698_g(pos);
				flag1 = true;
			}

			if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP)) {
				worldIn.func_175698_g(pos);
				flag1 = true;

				if (iblockstate1.func_177230_c() == this) {
					worldIn.func_175698_g(blockpos1);
				}
			}

			if (flag1) {
				if (!worldIn.field_72995_K) {
					this.func_176226_b(worldIn, pos, state, 0);
				}
			} else {
				boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos1);

				if (blockIn != this && (flag || blockIn.func_176223_P().func_185897_m()) && flag != iblockstate1.func_177229_b(POWERED)) {
					worldIn.func_180501_a(blockpos1, iblockstate1.func_177226_a(POWERED, flag), 2);

					if (flag != state.func_177229_b(OPEN)) {
						worldIn.func_180501_a(pos, state.func_177226_a(OPEN, flag), 2);
						worldIn.func_175704_b(pos, pos);
						worldIn.func_180498_a(null, flag ? 1006 : 1012, pos, 0);
					}
				}
			}
		}
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? null : Item.func_150898_a(state.func_177230_c());
	}

	@Override
	public boolean func_176196_c(World worldIn, BlockPos pos) {
		return pos.func_177956_o() < worldIn.func_72800_K() - 1 && (worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a()));
	}

	@Override
	public EnumPushReaction func_149656_h(IBlockState state) {
		return EnumPushReaction.DESTROY;
	}

	private static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
		IBlockState iblockstate = worldIn.func_180495_p(pos);
		int i = iblockstate.func_177230_c().func_176201_c(iblockstate);
		boolean flag = isTop(i);
		IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
		int j = iblockstate1.func_177230_c().func_176201_c(iblockstate1);
		int k = flag ? j : i;
		IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177984_a());
		int l = iblockstate2.func_177230_c().func_176201_c(iblockstate2);
		int i1 = flag ? i : l;
		boolean flag1 = (i1 & 1) != 0;
		boolean flag2 = (i1 & 2) != 0;
		return removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
	}

	@Override
	public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
		BlockPos blockpos = pos.func_177977_b();

		if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
			worldIn.func_175698_g(blockpos);
		}
	}

	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
		if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER) {
			IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());

			if (iblockstate.func_177230_c() == this) {
				state = state.func_177226_a(HINGE, iblockstate.func_177229_b(HINGE)).func_177226_a(POWERED, iblockstate.func_177229_b(POWERED));
			}
		} else {
			IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());

			if (iblockstate1.func_177230_c() == this) {
				state = state.func_177226_a(FACING, iblockstate1.func_177229_b(FACING)).func_177226_a(OPEN, iblockstate1.func_177229_b(OPEN));
			}
		}
		state = state.func_177226_a(CAMOUFLAGED, !CamouflageUtil.getCamouflageBlock(worldIn, pos).func_190926_b());

		return state;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, BlockDoor.EnumDoorHalf.UPPER).func_177226_a(HINGE, (meta & 1) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT).func_177226_a(POWERED, (meta & 2) > 0) : this.func_176223_P().func_177226_a(HALF, BlockDoor.EnumDoorHalf.LOWER).func_177226_a(FACING, EnumFacing.func_176731_b(meta & 3).func_176735_f()).func_177226_a(OPEN, (meta & 4) > 0);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.TRANSLUCENT;
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int i = 0;

		if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
			i = i | 8;

			if (state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT) {
				i |= 1;
			}

			if (state.func_177229_b(POWERED)) {
				i |= 2;
			}
		} else {
			i = i | state.func_177229_b(FACING).func_176746_e().func_176736_b();

			if (state.func_177229_b(OPEN)) {
				i |= 4;
			}
		}

		return i;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		ModelLoader.setCustomModelResourceLocation(item, 0, new ModelResourceLocation("forestry:greenhouse.door", "inventory"));
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new GreenhouseDoorStateMapper());
	}

	protected static int removeHalfBit(int meta) {
		return meta & 7;
	}

	public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
		return isOpen(combineMetadata(worldIn, pos));
	}

	public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
		return getFacing(combineMetadata(worldIn, pos));
	}

	public static EnumFacing getFacing(int combinedMeta) {
		return EnumFacing.func_176731_b(combinedMeta & 3).func_176735_f();
	}

	protected static boolean isOpen(int combinedMeta) {
		return (combinedMeta & 4) != 0;
	}

	protected static boolean isTop(int meta) {
		return (meta & 8) != 0;
	}

	protected static boolean isHingeLeft(int combinedMeta) {
		return (combinedMeta & 16) != 0;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new ExtendedBlockState(this, new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED, CAMOUFLAGED}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
	}

	@Override
	public BlockGreenhouseType getGreenhouseType() {
		return BlockGreenhouseType.DOOR;
	}

}
