package forestry.greenhouse.models;

import java.util.LinkedHashMap;
import java.util.Map;

import com.google.common.collect.Maps;
import forestry.core.render.ForestryStateMapper;
import forestry.greenhouse.blocks.BlockGreenhouseDoor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;

public class GreenhouseDoorStateMapper extends ForestryStateMapper {

	@Override
	public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
		for (IBlockState state : block.func_176194_O().func_177619_a()) {
			if (state.func_177229_b(BlockGreenhouseDoor.CAMOUFLAGED)) {
				mapStateModelLocations.put(state, new ModelResourceLocation(block.getRegistryName(), "camouflage"));
			} else {
				LinkedHashMap<IProperty<?>, Comparable<?>> linkedhashmap = Maps.newLinkedHashMap(state.func_177228_b());
				linkedhashmap.remove(BlockGreenhouseDoor.CAMOUFLAGED);
				linkedhashmap.remove(BlockDoor.field_176522_N);
				mapStateModelLocations.put(state, new ModelResourceLocation(block.getRegistryName(), getPropertyString(linkedhashmap)));
			}
		}
		return mapStateModelLocations;
	}

}
