/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.ForestryAPI;
import forestry.core.gui.GuiId;
import forestry.core.gui.GuiIdRegistry;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IGuiHandlerForestry;
import forestry.core.gui.IGuiHandlerItem;
import forestry.core.gui.IGuiHandlerTile;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiHandler
implements IGuiHandler {
    public static void openGui(EntityPlayer entityplayer, IGuiHandlerEntity guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerEntity guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.field_70170_p, guiHandler.getIdOfEntity(), 0, 0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerItem guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerItem guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.field_70170_p, 0, 0, 0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerTile guiHandler) {
        GuiHandler.openGui(entityplayer, guiHandler, (short)0);
    }

    public static void openGui(EntityPlayer entityplayer, IGuiHandlerTile guiHandler, short data) {
        int guiData = GuiHandler.encodeGuiData(guiHandler, data);
        BlockPos coordinates = guiHandler.getCoordinates();
        entityplayer.openGui(ForestryAPI.instance, guiData, entityplayer.field_70170_p, coordinates.func_177958_n(), coordinates.func_177956_o(), coordinates.func_177952_p());
    }

    private static int encodeGuiData(IGuiHandlerForestry guiHandler, short data) {
        GuiId guiId = GuiIdRegistry.getGuiIdForGuiHandler(guiHandler);
        return data << 16 | guiId.getId();
    }

    @Nullable
    private static GuiId decodeGuiID(int guiData) {
        int guiId = guiData & 0xFF;
        return GuiIdRegistry.getGuiId(guiId);
    }

    private static short decodeGuiData(int guiId) {
        return (short)(guiId >> 16);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int guiData, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = GuiHandler.decodeGuiID(guiData);
        if (guiId == null) {
            return null;
        }
        short data = GuiHandler.decodeGuiData(guiData);
        BlockPos pos = new BlockPos(x, y, z);
        switch (guiId.getGuiType()) {
            case Item: {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack heldItem = player.func_184586_b(hand);
                    if (heldItem.func_190926_b()) continue;
                    Item item = heldItem.func_77973_b();
                    if (!guiId.getGuiHandlerClass().isInstance(item)) continue;
                    return ((IGuiHandlerItem)item).getGui(player, heldItem, data);
                }
                break;
            }
            case Tile: {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!guiId.getGuiHandlerClass().isInstance(tileEntity)) break;
                return ((IGuiHandlerTile)tileEntity).getGui(player, data);
            }
            case Entity: {
                Entity entity = world.func_73045_a(x);
                if (!guiId.getGuiHandlerClass().isInstance(entity)) break;
                return ((IGuiHandlerEntity)entity).getGui(player, data);
            }
        }
        return null;
    }

    @Nullable
    public Object getServerGuiElement(int guiData, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = GuiHandler.decodeGuiID(guiData);
        if (guiId == null) {
            return null;
        }
        short data = GuiHandler.decodeGuiData(guiData);
        BlockPos pos = new BlockPos(x, y, z);
        switch (guiId.getGuiType()) {
            case Item: {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack heldItem = player.func_184586_b(hand);
                    if (heldItem.func_190926_b()) continue;
                    Item item = heldItem.func_77973_b();
                    if (!guiId.getGuiHandlerClass().isInstance(item)) continue;
                    return ((IGuiHandlerItem)item).getContainer(player, heldItem, data);
                }
                break;
            }
            case Tile: {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!guiId.getGuiHandlerClass().isInstance(tileEntity)) break;
                return ((IGuiHandlerTile)tileEntity).getContainer(player, data);
            }
            case Entity: {
                Entity entity = world.func_73045_a(x);
                if (!guiId.getGuiHandlerClass().isInstance(entity)) break;
                return ((IGuiHandlerEntity)entity).getContainer(player, data);
            }
        }
        return null;
    }
}

