/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicHomogeneous
extends FarmLogic {
    private final List<Soil> soils = new ArrayList<Soil>();
    protected final List<IFarmable> farmables;
    protected NonNullList<ItemStack> produce = NonNullList.func_191196_a();

    protected FarmLogicHomogeneous(ItemStack resource, IBlockState soilState, Collection<IFarmable> farmables) {
        this.addSoil(resource, soilState, false);
        this.farmables = new ArrayList<IFarmable>(farmables);
    }

    protected void addSoil(ItemStack resource, IBlockState soilState, boolean hasMetaData) {
        this.soils.add(new Soil(resource, soilState, hasMetaData));
    }

    protected boolean isAcceptedSoil(IBlockState blockState) {
        for (Soil soil : this.soils) {
            IBlockState soilState = soil.soilState;
            Block soilBlock = soilState.func_177230_c();
            Block block = blockState.func_177230_c();
            if (soilState.func_177230_c() != blockState.func_177230_c() || soil.hasMetaData && block.func_176201_c(blockState) != soilBlock.func_176201_c(soilState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        for (Soil soil : this.soils) {
            ItemStack resource = soil.resource;
            if (!resource.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.farmables) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.farmables) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return this.maintainSoil(world, farmHousing, pos, direction, extent) || this.maintainGermlings(world, farmHousing, pos.func_177984_a(), direction, extent);
    }

    private boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        block0: for (Soil soil : this.soils) {
            BlockPos position;
            IBlockState soilState;
            NonNullList resources = NonNullList.func_191196_a();
            resources.add((Object)soil.resource);
            if (!farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) continue;
            for (int i = 0; i < extent && !FarmHelper.bricks.contains((Object)(soilState = world.func_180495_p(position = this.translateWithOffset(pos, direction, i))).func_177230_c()); ++i) {
                if (this.isAcceptedSoil(soilState)) continue;
                BlockPos platformPosition = position.func_177977_b();
                IBlockState platformState = world.func_180495_p(platformPosition);
                if (!FarmHelper.bricks.contains((Object)platformState.func_177230_c())) continue block0;
                this.produce.addAll(BlockUtil.getBlockDrops(world, position));
                BlockUtil.setBlockWithPlaceSound(world, position, soil.soilState);
                farmHousing.getFarmInventory().removeResources((NonNullList<ItemStack>)resources);
                return true;
            }
        }
        return false;
    }

    protected abstract boolean maintainGermlings(World var1, IFarmHousing var2, BlockPos var3, FarmDirection var4, int var5);

    private static class Soil {
        protected final ItemStack resource;
        protected final IBlockState soilState;
        protected final boolean hasMetaData;

        public Soil(ItemStack resource, IBlockState soilState, boolean hasMetaData) {
            this.resource = resource;
            this.soilState = soilState;
            this.hasMetaData = hasMetaData;
        }
    }
}

