/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.core.render.TextureMapForestry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureManagerForestry
implements ITextureManager {
    public static final ResourceLocation LOCATION_FORESTRY_TEXTURE = new ResourceLocation("forestry", "textures/atlas/gui");
    private static final TextureManagerForestry INSTANCE = new TextureManagerForestry();
    private final List<ISpriteRegister> spriteRegisters = new ArrayList<ISpriteRegister>();
    private final TextureMapForestry textureMap = new TextureMapForestry("textures");

    public static TextureManagerForestry getInstance() {
        return INSTANCE;
    }

    private TextureManagerForestry() {
    }

    public TextureMapForestry getTextureMap() {
        return this.textureMap;
    }

    public static void initDefaultSprites() {
        String[] defaultIconNames;
        for (String identifier : defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "errors/errored", "errors/unknown", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"}) {
            ResourceLocation resourceLocation = TextureManagerForestry.getForestryGuiLocation(identifier);
            INSTANCE.registerGuiSprite(resourceLocation);
        }
    }

    private static ResourceLocation getForestryGuiLocation(String identifier) {
        return new ResourceLocation("forestry", "gui/" + identifier);
    }

    public static TextureAtlasSprite registerSprite(ResourceLocation location) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        return textureMap.func_174942_a(location);
    }

    @Override
    public TextureAtlasSprite getDefault(String identifier) {
        ResourceLocation resourceLocation = TextureManagerForestry.getForestryGuiLocation(identifier);
        return this.getTextureMap().func_110572_b(resourceLocation.toString());
    }

    @Override
    public ResourceLocation getGuiTextureMap() {
        return LOCATION_FORESTRY_TEXTURE;
    }

    public void bindGuiTextureMap() {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        ResourceLocation guiTextureMap = this.getGuiTextureMap();
        textureManager.func_110577_a(guiTextureMap);
    }

    @Override
    public TextureAtlasSprite registerGuiSprite(ResourceLocation location) {
        return this.getTextureMap().func_174942_a(location);
    }

    public void registerBlock(Block block) {
        if (block instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)block);
        }
    }

    public void registerItem(Item item) {
        if (item instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        for (ISpriteRegister spriteRegister : this.spriteRegisters) {
            spriteRegister.registerSprites(TextureManagerForestry.getInstance());
        }
    }

    static {
        ForestryAPI.textureManager = INSTANCE;
    }
}

