/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.inventory.InventoryHygroregulator;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.ILiquidTankTile;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAlvearyHygroregulator
extends TileAlveary
implements IInventory,
ILiquidTankTile,
IAlvearyComponent.Climatiser {
    private final HygroregulatorRecipe[] recipes;
    private final TankManager tankManager;
    private final FilteredTank liquidTank;
    private final IInventoryAdapter inventory = new InventoryHygroregulator(this);
    @Nullable
    private HygroregulatorRecipe currentRecipe;
    private int transferTime;

    public TileAlvearyHygroregulator() {
        super(BlockAlvearyType.HYGRO);
        Fluid water = FluidRegistry.WATER;
        Fluid lava = FluidRegistry.LAVA;
        Fluid liquidIce = Fluids.ICE.getFluid();
        this.liquidTank = new FilteredTank(10000).setFilters(water, lava, liquidIce);
        this.tankManager = new TankManager(this, this.liquidTank);
        this.recipes = new HygroregulatorRecipe[]{new HygroregulatorRecipe(new FluidStack(water, 1), 1, 0.01f, -0.005f), new HygroregulatorRecipe(new FluidStack(lava, 1), 10, -0.01f, 0.005f), new HygroregulatorRecipe(new FluidStack(liquidIce, 1), 10, 0.02f, -0.01f)};
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Nullable
    private HygroregulatorRecipe getRecipe(FluidStack liquid) {
        HygroregulatorRecipe recipe = null;
        for (HygroregulatorRecipe rec : this.recipes) {
            if (!rec.liquid.isFluidEqual(liquid)) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    @Override
    public void changeClimate(int tickCount, IClimateControlled climateControlled) {
        FluidStack fluid;
        if (this.transferTime <= 0 && (fluid = this.liquidTank.getFluid()) != null && fluid.amount > 0) {
            this.currentRecipe = this.getRecipe(fluid);
            if (this.currentRecipe != null) {
                this.liquidTank.drainInternal(this.currentRecipe.liquid.amount, true);
                this.transferTime = this.currentRecipe.transferTime;
            }
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            if (this.currentRecipe != null) {
                climateControlled.addHumidityChange(this.currentRecipe.humidChange, 0.0f, 1.0f);
                climateControlled.addTemperatureChange(this.currentRecipe.tempChange, 0.0f, 2.0f);
            } else {
                this.transferTime = 0;
            }
        }
        if (tickCount % 20 == 0) {
            FluidHelper.drainContainers(this.tankManager, this, 0);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.transferTime = nbttagcompound.func_74762_e("TransferTime");
        if (nbttagcompound.func_74764_b("CurrentLiquid")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("CurrentLiquid"));
            this.currentRecipe = this.getRecipe(liquid);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("TransferTime", this.transferTime);
        if (this.currentRecipe != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.currentRecipe.liquid.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("CurrentLiquid", (NBTBase)subcompound);
        }
        return nbttagcompound;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return (T)super.getCapability(capability, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiAlvearyHygroregulator(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerAlvearyHygroregulator(player.field_71071_by, this);
    }

    private static class HygroregulatorRecipe {
        public final FluidStack liquid;
        public final int transferTime;
        public final float humidChange;
        public final float tempChange;

        public HygroregulatorRecipe(FluidStack liquid, int transferTime, float humidChange, float tempChange) {
            this.liquid = liquid;
            this.transferTime = transferTime;
            this.humidChange = humidChange;
            this.tempChange = tempChange;
        }
    }
}

