/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.factory.network.packets;

import java.io.IOException;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileBase;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketRecipeTransferUpdate extends ForestryPacket implements IForestryPacketClient {
	private final BlockPos pos;
	private final NonNullList<ItemStack> craftingInventory;

	public PacketRecipeTransferUpdate(TileBase base, NonNullList<ItemStack> craftingInventory) {
		this.pos = base.func_174877_v();
		this.craftingInventory = craftingInventory;
	}

	@Override
	protected void writeData(PacketBufferForestry data) throws IOException {
		data.func_179255_a(pos);
		data.writeItemStacks(craftingInventory);
	}

	@Override
	public PacketIdClient getPacketId() {
		return PacketIdClient.RECIPE_TRANSFER_UPDATE;
	}

	@SideOnly(Side.CLIENT)
	public static class Handler implements IForestryPacketHandlerClient {
		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
			BlockPos pos = data.func_179259_c();
			NonNullList<ItemStack> craftingInventory = data.readItemStacks();

			TileEntity tile = player.field_70170_p.func_175625_s(pos);
			if (tile instanceof TileCarpenter) {
				TileCarpenter carpenter = (TileCarpenter) tile;
				int index = 0;
				for (ItemStack stack : craftingInventory) {
					carpenter.getCraftingInventory().func_70299_a(index, stack);
					index++;
				}
			} else if (tile instanceof TileFabricator) {
				TileFabricator fabricator = (TileFabricator) tile;
				int index = 0;
				for (ItemStack stack : craftingInventory) {
					fabricator.getCraftingInventory().func_70299_a(index, stack);
					index++;
				}
			}
		}
	}
}
